// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Provides information about the EC2 instances in a cluster grouped by category. For
 * example, key name, subnet ID, IAM instance profile, and so on.
 */
class Ec2InstanceAttributes private constructor(builder: Builder) {
    /**
     * A list of additional Amazon EC2 security group IDs for the master node.
     */
    val additionalMasterSecurityGroups: List<String>? = builder.additionalMasterSecurityGroups
    /**
     * A list of additional Amazon EC2 security group IDs for the core and task nodes.
     */
    val additionalSlaveSecurityGroups: List<String>? = builder.additionalSlaveSecurityGroups
    /**
     * The Availability Zone in which the cluster will run.
     */
    val ec2AvailabilityZone: kotlin.String? = builder.ec2AvailabilityZone
    /**
     * The name of the Amazon EC2 key pair to use when connecting with SSH into the master node
     * as a user named "hadoop".
     */
    val ec2KeyName: kotlin.String? = builder.ec2KeyName
    /**
     * Set this parameter to the identifier of the Amazon VPC subnet where you want the cluster
     * to launch. If you do not specify this value, and your account supports EC2-Classic, the
     * cluster launches in EC2-Classic.
     */
    val ec2SubnetId: kotlin.String? = builder.ec2SubnetId
    /**
     * The identifier of the Amazon EC2 security group for the master node.
     */
    val emrManagedMasterSecurityGroup: kotlin.String? = builder.emrManagedMasterSecurityGroup
    /**
     * The identifier of the Amazon EC2 security group for the core and task nodes.
     */
    val emrManagedSlaveSecurityGroup: kotlin.String? = builder.emrManagedSlaveSecurityGroup
    /**
     * The IAM role that was specified when the cluster was launched. The EC2 instances of the
     * cluster assume this role.
     */
    val iamInstanceProfile: kotlin.String? = builder.iamInstanceProfile
    /**
     * Applies to clusters configured with the instance fleets option. Specifies one or more
     * Availability Zones in which to launch EC2 cluster instances when the EC2-Classic network
     * configuration is supported. Amazon EMR chooses the Availability Zone with the best fit from
     * among the list of RequestedEc2AvailabilityZones, and then launches all cluster
     * instances within that Availability Zone. If you do not specify this value, Amazon EMR
     * chooses the Availability Zone for you. RequestedEc2SubnetIDs and
     * RequestedEc2AvailabilityZones cannot be specified together.
     */
    val requestedEc2AvailabilityZones: List<String>? = builder.requestedEc2AvailabilityZones
    /**
     * Applies to clusters configured with the instance fleets option. Specifies the unique
     * identifier of one or more Amazon EC2 subnets in which to launch EC2 cluster instances.
     * Subnets must exist within the same VPC. Amazon EMR chooses the EC2 subnet with the best fit
     * from among the list of RequestedEc2SubnetIds, and then launches all cluster
     * instances within that Subnet. If this value is not specified, and the account and Region
     * support EC2-Classic networks, the cluster launches instances in the EC2-Classic network and
     * uses RequestedEc2AvailabilityZones instead of this setting. If EC2-Classic is
     * not supported, and no Subnet is specified, Amazon EMR chooses the subnet for you.
     * RequestedEc2SubnetIDs and RequestedEc2AvailabilityZones cannot
     * be specified together.
     */
    val requestedEc2SubnetIds: List<String>? = builder.requestedEc2SubnetIds
    /**
     * The identifier of the Amazon EC2 security group for the Amazon EMR service to access
     * clusters in VPC private subnets.
     */
    val serviceAccessSecurityGroup: kotlin.String? = builder.serviceAccessSecurityGroup

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.Ec2InstanceAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2InstanceAttributes(")
        append("additionalMasterSecurityGroups=$additionalMasterSecurityGroups,")
        append("additionalSlaveSecurityGroups=$additionalSlaveSecurityGroups,")
        append("ec2AvailabilityZone=$ec2AvailabilityZone,")
        append("ec2KeyName=$ec2KeyName,")
        append("ec2SubnetId=$ec2SubnetId,")
        append("emrManagedMasterSecurityGroup=$emrManagedMasterSecurityGroup,")
        append("emrManagedSlaveSecurityGroup=$emrManagedSlaveSecurityGroup,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("requestedEc2AvailabilityZones=$requestedEc2AvailabilityZones,")
        append("requestedEc2SubnetIds=$requestedEc2SubnetIds,")
        append("serviceAccessSecurityGroup=$serviceAccessSecurityGroup)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalMasterSecurityGroups?.hashCode() ?: 0
        result = 31 * result + (additionalSlaveSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (ec2AvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (ec2KeyName?.hashCode() ?: 0)
        result = 31 * result + (ec2SubnetId?.hashCode() ?: 0)
        result = 31 * result + (emrManagedMasterSecurityGroup?.hashCode() ?: 0)
        result = 31 * result + (emrManagedSlaveSecurityGroup?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (requestedEc2AvailabilityZones?.hashCode() ?: 0)
        result = 31 * result + (requestedEc2SubnetIds?.hashCode() ?: 0)
        result = 31 * result + (serviceAccessSecurityGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2InstanceAttributes

        if (additionalMasterSecurityGroups != other.additionalMasterSecurityGroups) return false
        if (additionalSlaveSecurityGroups != other.additionalSlaveSecurityGroups) return false
        if (ec2AvailabilityZone != other.ec2AvailabilityZone) return false
        if (ec2KeyName != other.ec2KeyName) return false
        if (ec2SubnetId != other.ec2SubnetId) return false
        if (emrManagedMasterSecurityGroup != other.emrManagedMasterSecurityGroup) return false
        if (emrManagedSlaveSecurityGroup != other.emrManagedSlaveSecurityGroup) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (requestedEc2AvailabilityZones != other.requestedEc2AvailabilityZones) return false
        if (requestedEc2SubnetIds != other.requestedEc2SubnetIds) return false
        if (serviceAccessSecurityGroup != other.serviceAccessSecurityGroup) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.Ec2InstanceAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of additional Amazon EC2 security group IDs for the master node.
         */
        var additionalMasterSecurityGroups: List<String>? = null
        /**
         * A list of additional Amazon EC2 security group IDs for the core and task nodes.
         */
        var additionalSlaveSecurityGroups: List<String>? = null
        /**
         * The Availability Zone in which the cluster will run.
         */
        var ec2AvailabilityZone: kotlin.String? = null
        /**
         * The name of the Amazon EC2 key pair to use when connecting with SSH into the master node
         * as a user named "hadoop".
         */
        var ec2KeyName: kotlin.String? = null
        /**
         * Set this parameter to the identifier of the Amazon VPC subnet where you want the cluster
         * to launch. If you do not specify this value, and your account supports EC2-Classic, the
         * cluster launches in EC2-Classic.
         */
        var ec2SubnetId: kotlin.String? = null
        /**
         * The identifier of the Amazon EC2 security group for the master node.
         */
        var emrManagedMasterSecurityGroup: kotlin.String? = null
        /**
         * The identifier of the Amazon EC2 security group for the core and task nodes.
         */
        var emrManagedSlaveSecurityGroup: kotlin.String? = null
        /**
         * The IAM role that was specified when the cluster was launched. The EC2 instances of the
         * cluster assume this role.
         */
        var iamInstanceProfile: kotlin.String? = null
        /**
         * Applies to clusters configured with the instance fleets option. Specifies one or more
         * Availability Zones in which to launch EC2 cluster instances when the EC2-Classic network
         * configuration is supported. Amazon EMR chooses the Availability Zone with the best fit from
         * among the list of RequestedEc2AvailabilityZones, and then launches all cluster
         * instances within that Availability Zone. If you do not specify this value, Amazon EMR
         * chooses the Availability Zone for you. RequestedEc2SubnetIDs and
         * RequestedEc2AvailabilityZones cannot be specified together.
         */
        var requestedEc2AvailabilityZones: List<String>? = null
        /**
         * Applies to clusters configured with the instance fleets option. Specifies the unique
         * identifier of one or more Amazon EC2 subnets in which to launch EC2 cluster instances.
         * Subnets must exist within the same VPC. Amazon EMR chooses the EC2 subnet with the best fit
         * from among the list of RequestedEc2SubnetIds, and then launches all cluster
         * instances within that Subnet. If this value is not specified, and the account and Region
         * support EC2-Classic networks, the cluster launches instances in the EC2-Classic network and
         * uses RequestedEc2AvailabilityZones instead of this setting. If EC2-Classic is
         * not supported, and no Subnet is specified, Amazon EMR chooses the subnet for you.
         * RequestedEc2SubnetIDs and RequestedEc2AvailabilityZones cannot
         * be specified together.
         */
        var requestedEc2SubnetIds: List<String>? = null
        /**
         * The identifier of the Amazon EC2 security group for the Amazon EMR service to access
         * clusters in VPC private subnets.
         */
        var serviceAccessSecurityGroup: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.Ec2InstanceAttributes) : this() {
            this.additionalMasterSecurityGroups = x.additionalMasterSecurityGroups
            this.additionalSlaveSecurityGroups = x.additionalSlaveSecurityGroups
            this.ec2AvailabilityZone = x.ec2AvailabilityZone
            this.ec2KeyName = x.ec2KeyName
            this.ec2SubnetId = x.ec2SubnetId
            this.emrManagedMasterSecurityGroup = x.emrManagedMasterSecurityGroup
            this.emrManagedSlaveSecurityGroup = x.emrManagedSlaveSecurityGroup
            this.iamInstanceProfile = x.iamInstanceProfile
            this.requestedEc2AvailabilityZones = x.requestedEc2AvailabilityZones
            this.requestedEc2SubnetIds = x.requestedEc2SubnetIds
            this.serviceAccessSecurityGroup = x.serviceAccessSecurityGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.Ec2InstanceAttributes = Ec2InstanceAttributes(this)
    }
}
