// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Specifies the execution engine (cluster) to run the notebook and perform the notebook
 * execution, for example, an EMR cluster.
 */
class ExecutionEngineConfig private constructor(builder: Builder) {
    /**
     * The unique identifier of the execution engine. For an EMR cluster, this is the cluster
     * ID.
     */
    val id: kotlin.String? = builder.id
    /**
     * An optional unique ID of an EC2 security group to associate with the master instance of
     * the EMR cluster for this notebook execution. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
     * EC2 Security Groups for EMR Notebooks in the EMR Management
     * Guide.
     */
    val masterInstanceSecurityGroupId: kotlin.String? = builder.masterInstanceSecurityGroupId
    /**
     * The type of execution engine. A value of EMR specifies an EMR
     * cluster.
     */
    val type: aws.sdk.kotlin.services.emr.model.ExecutionEngineType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecutionEngineConfig(")
        append("id=$id,")
        append("masterInstanceSecurityGroupId=$masterInstanceSecurityGroupId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (masterInstanceSecurityGroupId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecutionEngineConfig

        if (id != other.id) return false
        if (masterInstanceSecurityGroupId != other.masterInstanceSecurityGroupId) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier of the execution engine. For an EMR cluster, this is the cluster
         * ID.
         */
        var id: kotlin.String? = null
        /**
         * An optional unique ID of an EC2 security group to associate with the master instance of
         * the EMR cluster for this notebook execution. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
         * EC2 Security Groups for EMR Notebooks in the EMR Management
         * Guide.
         */
        var masterInstanceSecurityGroupId: kotlin.String? = null
        /**
         * The type of execution engine. A value of EMR specifies an EMR
         * cluster.
         */
        var type: aws.sdk.kotlin.services.emr.model.ExecutionEngineType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig) : this() {
            this.id = x.id
            this.masterInstanceSecurityGroupId = x.masterInstanceSecurityGroupId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig = ExecutionEngineConfig(this)
    }
}
