// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * A cluster step consisting of a JAR file whose main function will be executed. The main
 * function submits a job for Hadoop to execute and waits for the job to finish or
 * fail.
 */
class HadoopStepConfig private constructor(builder: Builder) {
    /**
     * The list of command line arguments to pass to the JAR file's main function for
     * execution.
     */
    val args: List<String>? = builder.args
    /**
     * The path to the JAR file that runs during the step.
     */
    val jar: kotlin.String? = builder.jar
    /**
     * The name of the main class in the specified Java file. If not specified, the JAR file
     * should specify a main class in its manifest file.
     */
    val mainClass: kotlin.String? = builder.mainClass
    /**
     * The list of Java properties that are set when the step runs. You can use these
     * properties to pass key-value pairs to your main function.
     */
    val properties: Map<String, String>? = builder.properties

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.HadoopStepConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HadoopStepConfig(")
        append("args=$args,")
        append("jar=$jar,")
        append("mainClass=$mainClass,")
        append("properties=$properties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = args?.hashCode() ?: 0
        result = 31 * result + (jar?.hashCode() ?: 0)
        result = 31 * result + (mainClass?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HadoopStepConfig

        if (args != other.args) return false
        if (jar != other.jar) return false
        if (mainClass != other.mainClass) return false
        if (properties != other.properties) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.HadoopStepConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The list of command line arguments to pass to the JAR file's main function for
         * execution.
         */
        var args: List<String>? = null
        /**
         * The path to the JAR file that runs during the step.
         */
        var jar: kotlin.String? = null
        /**
         * The name of the main class in the specified Java file. If not specified, the JAR file
         * should specify a main class in its manifest file.
         */
        var mainClass: kotlin.String? = null
        /**
         * The list of Java properties that are set when the step runs. You can use these
         * properties to pass key-value pairs to your main function.
         */
        var properties: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.HadoopStepConfig) : this() {
            this.args = x.args
            this.jar = x.jar
            this.mainClass = x.mainClass
            this.properties = x.properties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.HadoopStepConfig = HadoopStepConfig(this)
    }
}
