// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Configuration defining a new instance group.
 */
class InstanceGroupConfig private constructor(builder: Builder) {
    /**
     * An automatic scaling policy for a core instance group or task instance group in an
     * Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
     * adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
     * PutAutoScalingPolicy.
     */
    val autoScalingPolicy: aws.sdk.kotlin.services.emr.model.AutoScalingPolicy? = builder.autoScalingPolicy
    /**
     * If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify OnDemandPrice to set the amount equal to the On-Demand price, or specify an amount in USD.
     */
    val bidPrice: kotlin.String? = builder.bidPrice
    /**
     * Amazon EMR releases 4.x or later.
     *
     * The list of configurations supplied for an EMR cluster instance group. You can specify a
     * separate configuration for each instance group (master, core, and task).
     */
    val configurations: List<Configuration>? = builder.configurations
    /**
     * The custom AMI ID to use for the provisioned instance group.
     */
    val customAmiId: kotlin.String? = builder.customAmiId
    /**
     * EBS configurations that will be attached to each EC2 instance in the instance
     * group.
     */
    val ebsConfiguration: aws.sdk.kotlin.services.emr.model.EbsConfiguration? = builder.ebsConfiguration
    /**
     * Target number of instances for the instance group.
     */
    val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The role of the instance group in the cluster.
     */
    val instanceRole: aws.sdk.kotlin.services.emr.model.InstanceRoleType? = builder.instanceRole
    /**
     * The EC2 instance type for all instances in the instance group.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * Market type of the EC2 instances used to create a cluster node.
     */
    val market: aws.sdk.kotlin.services.emr.model.MarketType? = builder.market
    /**
     * Friendly name given to the instance group.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceGroupConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceGroupConfig(")
        append("autoScalingPolicy=$autoScalingPolicy,")
        append("bidPrice=$bidPrice,")
        append("configurations=$configurations,")
        append("customAmiId=$customAmiId,")
        append("ebsConfiguration=$ebsConfiguration,")
        append("instanceCount=$instanceCount,")
        append("instanceRole=$instanceRole,")
        append("instanceType=$instanceType,")
        append("market=$market,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingPolicy?.hashCode() ?: 0
        result = 31 * result + (bidPrice?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (customAmiId?.hashCode() ?: 0)
        result = 31 * result + (ebsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceRole?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (market?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceGroupConfig

        if (autoScalingPolicy != other.autoScalingPolicy) return false
        if (bidPrice != other.bidPrice) return false
        if (configurations != other.configurations) return false
        if (customAmiId != other.customAmiId) return false
        if (ebsConfiguration != other.ebsConfiguration) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceRole != other.instanceRole) return false
        if (instanceType != other.instanceType) return false
        if (market != other.market) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceGroupConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * An automatic scaling policy for a core instance group or task instance group in an
         * Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
         * adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
         * PutAutoScalingPolicy.
         */
        var autoScalingPolicy: aws.sdk.kotlin.services.emr.model.AutoScalingPolicy? = null
        /**
         * If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify OnDemandPrice to set the amount equal to the On-Demand price, or specify an amount in USD.
         */
        var bidPrice: kotlin.String? = null
        /**
         * Amazon EMR releases 4.x or later.
         *
         * The list of configurations supplied for an EMR cluster instance group. You can specify a
         * separate configuration for each instance group (master, core, and task).
         */
        var configurations: List<Configuration>? = null
        /**
         * The custom AMI ID to use for the provisioned instance group.
         */
        var customAmiId: kotlin.String? = null
        /**
         * EBS configurations that will be attached to each EC2 instance in the instance
         * group.
         */
        var ebsConfiguration: aws.sdk.kotlin.services.emr.model.EbsConfiguration? = null
        /**
         * Target number of instances for the instance group.
         */
        var instanceCount: kotlin.Int? = null
        /**
         * The role of the instance group in the cluster.
         */
        var instanceRole: aws.sdk.kotlin.services.emr.model.InstanceRoleType? = null
        /**
         * The EC2 instance type for all instances in the instance group.
         */
        var instanceType: kotlin.String? = null
        /**
         * Market type of the EC2 instances used to create a cluster node.
         */
        var market: aws.sdk.kotlin.services.emr.model.MarketType? = null
        /**
         * Friendly name given to the instance group.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceGroupConfig) : this() {
            this.autoScalingPolicy = x.autoScalingPolicy
            this.bidPrice = x.bidPrice
            this.configurations = x.configurations
            this.customAmiId = x.customAmiId
            this.ebsConfiguration = x.ebsConfiguration
            this.instanceCount = x.instanceCount
            this.instanceRole = x.instanceRole
            this.instanceType = x.instanceType
            this.market = x.market
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceGroupConfig = InstanceGroupConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.AutoScalingPolicy] inside the given [block]
         */
        fun autoScalingPolicy(block: aws.sdk.kotlin.services.emr.model.AutoScalingPolicy.Builder.() -> kotlin.Unit) {
            this.autoScalingPolicy = aws.sdk.kotlin.services.emr.model.AutoScalingPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.EbsConfiguration] inside the given [block]
         */
        fun ebsConfiguration(block: aws.sdk.kotlin.services.emr.model.EbsConfiguration.Builder.() -> kotlin.Unit) {
            this.ebsConfiguration = aws.sdk.kotlin.services.emr.model.EbsConfiguration.invoke(block)
        }
    }
}
