// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Specify the type of Amazon EC2 instances that the cluster (job flow) runs on.
 */
class JobFlowInstancesDetail private constructor(builder: Builder) {
    /**
     * The name of an Amazon EC2 key pair that can be used to connect to the master node using
     * SSH.
     */
    val ec2KeyName: kotlin.String? = builder.ec2KeyName
    /**
     * For clusters launched within Amazon Virtual Private Cloud, this is the identifier of the
     * subnet where the cluster was launched.
     */
    val ec2SubnetId: kotlin.String? = builder.ec2SubnetId
    /**
     * The Hadoop version for the cluster.
     */
    val hadoopVersion: kotlin.String? = builder.hadoopVersion
    /**
     * The number of Amazon EC2 instances in the cluster. If the value is 1, the same instance
     * serves as both the master and core and task node. If the value is greater than 1, one
     * instance is the master node and all others are core and task nodes.
     */
    val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * Details about the instance groups in a cluster.
     */
    val instanceGroups: List<InstanceGroupDetail>? = builder.instanceGroups
    /**
     * Specifies whether the cluster should remain available after completing all steps.
     */
    val keepJobFlowAliveWhenNoSteps: kotlin.Boolean = builder.keepJobFlowAliveWhenNoSteps
    /**
     * The Amazon EC2 instance identifier of the master node.
     */
    val masterInstanceId: kotlin.String? = builder.masterInstanceId
    /**
     * The Amazon EC2 master node instance type.
     */
    val masterInstanceType: kotlin.String? = builder.masterInstanceType
    /**
     * The DNS name of the master node. If the cluster is on a private subnet, this is the
     * private DNS name. On a public subnet, this is the public DNS name.
     */
    val masterPublicDnsName: kotlin.String? = builder.masterPublicDnsName
    /**
     * An approximation of the cost of the cluster, represented in m1.small/hours. This value
     * is increased one time for every hour that an m1.small instance runs. Larger instances are
     * weighted more heavily, so an Amazon EC2 instance that is roughly four times more expensive
     * would result in the normalized instance hours being increased incrementally four times.
     * This result is only an approximation and does not reflect the actual billing rate.
     */
    val normalizedInstanceHours: kotlin.Int? = builder.normalizedInstanceHours
    /**
     * The Amazon EC2 Availability Zone for the cluster.
     */
    val placement: aws.sdk.kotlin.services.emr.model.PlacementType? = builder.placement
    /**
     * The Amazon EC2 core and task node instance type.
     */
    val slaveInstanceType: kotlin.String? = builder.slaveInstanceType
    /**
     * Specifies whether the Amazon EC2 instances in the cluster are protected from termination
     * by API calls, user intervention, or in the event of a job-flow error.
     */
    val terminationProtected: kotlin.Boolean = builder.terminationProtected

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.JobFlowInstancesDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobFlowInstancesDetail(")
        append("ec2KeyName=$ec2KeyName,")
        append("ec2SubnetId=$ec2SubnetId,")
        append("hadoopVersion=$hadoopVersion,")
        append("instanceCount=$instanceCount,")
        append("instanceGroups=$instanceGroups,")
        append("keepJobFlowAliveWhenNoSteps=$keepJobFlowAliveWhenNoSteps,")
        append("masterInstanceId=$masterInstanceId,")
        append("masterInstanceType=$masterInstanceType,")
        append("masterPublicDnsName=$masterPublicDnsName,")
        append("normalizedInstanceHours=$normalizedInstanceHours,")
        append("placement=$placement,")
        append("slaveInstanceType=$slaveInstanceType,")
        append("terminationProtected=$terminationProtected)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ec2KeyName?.hashCode() ?: 0
        result = 31 * result + (ec2SubnetId?.hashCode() ?: 0)
        result = 31 * result + (hadoopVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceGroups?.hashCode() ?: 0)
        result = 31 * result + (keepJobFlowAliveWhenNoSteps.hashCode())
        result = 31 * result + (masterInstanceId?.hashCode() ?: 0)
        result = 31 * result + (masterInstanceType?.hashCode() ?: 0)
        result = 31 * result + (masterPublicDnsName?.hashCode() ?: 0)
        result = 31 * result + (normalizedInstanceHours ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (slaveInstanceType?.hashCode() ?: 0)
        result = 31 * result + (terminationProtected.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobFlowInstancesDetail

        if (ec2KeyName != other.ec2KeyName) return false
        if (ec2SubnetId != other.ec2SubnetId) return false
        if (hadoopVersion != other.hadoopVersion) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceGroups != other.instanceGroups) return false
        if (keepJobFlowAliveWhenNoSteps != other.keepJobFlowAliveWhenNoSteps) return false
        if (masterInstanceId != other.masterInstanceId) return false
        if (masterInstanceType != other.masterInstanceType) return false
        if (masterPublicDnsName != other.masterPublicDnsName) return false
        if (normalizedInstanceHours != other.normalizedInstanceHours) return false
        if (placement != other.placement) return false
        if (slaveInstanceType != other.slaveInstanceType) return false
        if (terminationProtected != other.terminationProtected) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.JobFlowInstancesDetail = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of an Amazon EC2 key pair that can be used to connect to the master node using
         * SSH.
         */
        var ec2KeyName: kotlin.String? = null
        /**
         * For clusters launched within Amazon Virtual Private Cloud, this is the identifier of the
         * subnet where the cluster was launched.
         */
        var ec2SubnetId: kotlin.String? = null
        /**
         * The Hadoop version for the cluster.
         */
        var hadoopVersion: kotlin.String? = null
        /**
         * The number of Amazon EC2 instances in the cluster. If the value is 1, the same instance
         * serves as both the master and core and task node. If the value is greater than 1, one
         * instance is the master node and all others are core and task nodes.
         */
        var instanceCount: kotlin.Int? = null
        /**
         * Details about the instance groups in a cluster.
         */
        var instanceGroups: List<InstanceGroupDetail>? = null
        /**
         * Specifies whether the cluster should remain available after completing all steps.
         */
        var keepJobFlowAliveWhenNoSteps: kotlin.Boolean = false
        /**
         * The Amazon EC2 instance identifier of the master node.
         */
        var masterInstanceId: kotlin.String? = null
        /**
         * The Amazon EC2 master node instance type.
         */
        var masterInstanceType: kotlin.String? = null
        /**
         * The DNS name of the master node. If the cluster is on a private subnet, this is the
         * private DNS name. On a public subnet, this is the public DNS name.
         */
        var masterPublicDnsName: kotlin.String? = null
        /**
         * An approximation of the cost of the cluster, represented in m1.small/hours. This value
         * is increased one time for every hour that an m1.small instance runs. Larger instances are
         * weighted more heavily, so an Amazon EC2 instance that is roughly four times more expensive
         * would result in the normalized instance hours being increased incrementally four times.
         * This result is only an approximation and does not reflect the actual billing rate.
         */
        var normalizedInstanceHours: kotlin.Int? = null
        /**
         * The Amazon EC2 Availability Zone for the cluster.
         */
        var placement: aws.sdk.kotlin.services.emr.model.PlacementType? = null
        /**
         * The Amazon EC2 core and task node instance type.
         */
        var slaveInstanceType: kotlin.String? = null
        /**
         * Specifies whether the Amazon EC2 instances in the cluster are protected from termination
         * by API calls, user intervention, or in the event of a job-flow error.
         */
        var terminationProtected: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.JobFlowInstancesDetail) : this() {
            this.ec2KeyName = x.ec2KeyName
            this.ec2SubnetId = x.ec2SubnetId
            this.hadoopVersion = x.hadoopVersion
            this.instanceCount = x.instanceCount
            this.instanceGroups = x.instanceGroups
            this.keepJobFlowAliveWhenNoSteps = x.keepJobFlowAliveWhenNoSteps
            this.masterInstanceId = x.masterInstanceId
            this.masterInstanceType = x.masterInstanceType
            this.masterPublicDnsName = x.masterPublicDnsName
            this.normalizedInstanceHours = x.normalizedInstanceHours
            this.placement = x.placement
            this.slaveInstanceType = x.slaveInstanceType
            this.terminationProtected = x.terminationProtected
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.JobFlowInstancesDetail = JobFlowInstancesDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.PlacementType] inside the given [block]
         */
        fun placement(block: aws.sdk.kotlin.services.emr.model.PlacementType.Builder.() -> kotlin.Unit) {
            this.placement = aws.sdk.kotlin.services.emr.model.PlacementType.invoke(block)
        }
    }
}
