// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A notebook execution. An execution is a specific instance that an EMR Notebook is run
 * using the StartNotebookExecution action.
 */
class NotebookExecution private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the notebook execution.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier of the EMR Notebook that is used for the notebook
     * execution.
     */
    val editorId: kotlin.String? = builder.editorId
    /**
     * The timestamp when notebook execution ended.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The execution engine, such as an EMR cluster, used to run the EMR notebook and perform
     * the notebook execution.
     */
    val executionEngine: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig? = builder.executionEngine
    /**
     * The reason for the latest status change of the notebook execution.
     */
    val lastStateChangeReason: kotlin.String? = builder.lastStateChangeReason
    /**
     * The unique identifier of a notebook execution.
     */
    val notebookExecutionId: kotlin.String? = builder.notebookExecutionId
    /**
     * A name for the notebook execution.
     */
    val notebookExecutionName: kotlin.String? = builder.notebookExecutionName
    /**
     * The unique identifier of the EC2 security group associated with the EMR Notebook
     * instance. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
     * EC2 Security Groups for EMR Notebooks in the EMR Management
     * Guide.
     */
    val notebookInstanceSecurityGroupId: kotlin.String? = builder.notebookInstanceSecurityGroupId
    /**
     * Input parameters in JSON format passed to the EMR Notebook at runtime for
     * execution.
     */
    val notebookParams: kotlin.String? = builder.notebookParams
    /**
     * The location of the notebook execution's output file in Amazon S3.
     */
    val outputNotebookUri: kotlin.String? = builder.outputNotebookUri
    /**
     * The timestamp when notebook execution started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the notebook execution.
     *
     *
     *
     * START_PENDING indicates that the cluster has received the execution
     * request but execution has not begun.
     *
     *
     * STARTING indicates that the execution is starting on the
     * cluster.
     *
     *
     * RUNNING indicates that the execution is being processed by the
     * cluster.
     *
     *
     * FINISHING indicates that execution processing is in the final
     * stages.
     *
     *
     * FINISHED indicates that the execution has completed without
     * error.
     *
     *
     * FAILING indicates that the execution is failing and will not finish
     * successfully.
     *
     *
     * FAILED indicates that the execution failed.
     *
     *
     * STOP_PENDING indicates that the cluster has received a
     * StopNotebookExecution request and the stop is pending.
     *
     *
     * STOPPING indicates that the cluster is in the process of stopping the
     * execution as a result of a StopNotebookExecution request.
     *
     *
     * STOPPED indicates that the execution stopped because of a
     * StopNotebookExecution request.
     */
    val status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = builder.status
    /**
     * A list of tags associated with a notebook execution. Tags are user-defined key-value
     * pairs that consist of a required key string with a maximum of 128 characters and an
     * optional value string with a maximum of 256 characters.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.NotebookExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotebookExecution(")
        append("arn=$arn,")
        append("editorId=$editorId,")
        append("endTime=$endTime,")
        append("executionEngine=$executionEngine,")
        append("lastStateChangeReason=$lastStateChangeReason,")
        append("notebookExecutionId=$notebookExecutionId,")
        append("notebookExecutionName=$notebookExecutionName,")
        append("notebookInstanceSecurityGroupId=$notebookInstanceSecurityGroupId,")
        append("notebookParams=$notebookParams,")
        append("outputNotebookUri=$outputNotebookUri,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (editorId?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (executionEngine?.hashCode() ?: 0)
        result = 31 * result + (lastStateChangeReason?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionId?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceSecurityGroupId?.hashCode() ?: 0)
        result = 31 * result + (notebookParams?.hashCode() ?: 0)
        result = 31 * result + (outputNotebookUri?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotebookExecution

        if (arn != other.arn) return false
        if (editorId != other.editorId) return false
        if (endTime != other.endTime) return false
        if (executionEngine != other.executionEngine) return false
        if (lastStateChangeReason != other.lastStateChangeReason) return false
        if (notebookExecutionId != other.notebookExecutionId) return false
        if (notebookExecutionName != other.notebookExecutionName) return false
        if (notebookInstanceSecurityGroupId != other.notebookInstanceSecurityGroupId) return false
        if (notebookParams != other.notebookParams) return false
        if (outputNotebookUri != other.outputNotebookUri) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.NotebookExecution = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the notebook execution.
         */
        var arn: kotlin.String? = null
        /**
         * The unique identifier of the EMR Notebook that is used for the notebook
         * execution.
         */
        var editorId: kotlin.String? = null
        /**
         * The timestamp when notebook execution ended.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The execution engine, such as an EMR cluster, used to run the EMR notebook and perform
         * the notebook execution.
         */
        var executionEngine: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig? = null
        /**
         * The reason for the latest status change of the notebook execution.
         */
        var lastStateChangeReason: kotlin.String? = null
        /**
         * The unique identifier of a notebook execution.
         */
        var notebookExecutionId: kotlin.String? = null
        /**
         * A name for the notebook execution.
         */
        var notebookExecutionName: kotlin.String? = null
        /**
         * The unique identifier of the EC2 security group associated with the EMR Notebook
         * instance. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying
         * EC2 Security Groups for EMR Notebooks in the EMR Management
         * Guide.
         */
        var notebookInstanceSecurityGroupId: kotlin.String? = null
        /**
         * Input parameters in JSON format passed to the EMR Notebook at runtime for
         * execution.
         */
        var notebookParams: kotlin.String? = null
        /**
         * The location of the notebook execution's output file in Amazon S3.
         */
        var outputNotebookUri: kotlin.String? = null
        /**
         * The timestamp when notebook execution started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the notebook execution.
         *
         *
         *
         * START_PENDING indicates that the cluster has received the execution
         * request but execution has not begun.
         *
         *
         * STARTING indicates that the execution is starting on the
         * cluster.
         *
         *
         * RUNNING indicates that the execution is being processed by the
         * cluster.
         *
         *
         * FINISHING indicates that execution processing is in the final
         * stages.
         *
         *
         * FINISHED indicates that the execution has completed without
         * error.
         *
         *
         * FAILING indicates that the execution is failing and will not finish
         * successfully.
         *
         *
         * FAILED indicates that the execution failed.
         *
         *
         * STOP_PENDING indicates that the cluster has received a
         * StopNotebookExecution request and the stop is pending.
         *
         *
         * STOPPING indicates that the cluster is in the process of stopping the
         * execution as a result of a StopNotebookExecution request.
         *
         *
         * STOPPED indicates that the execution stopped because of a
         * StopNotebookExecution request.
         */
        var status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = null
        /**
         * A list of tags associated with a notebook execution. Tags are user-defined key-value
         * pairs that consist of a required key string with a maximum of 128 characters and an
         * optional value string with a maximum of 256 characters.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.NotebookExecution) : this() {
            this.arn = x.arn
            this.editorId = x.editorId
            this.endTime = x.endTime
            this.executionEngine = x.executionEngine
            this.lastStateChangeReason = x.lastStateChangeReason
            this.notebookExecutionId = x.notebookExecutionId
            this.notebookExecutionName = x.notebookExecutionName
            this.notebookInstanceSecurityGroupId = x.notebookInstanceSecurityGroupId
            this.notebookParams = x.notebookParams
            this.outputNotebookUri = x.outputNotebookUri
            this.startTime = x.startTime
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.NotebookExecution = NotebookExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig] inside the given [block]
         */
        fun executionEngine(block: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig.Builder.() -> kotlin.Unit) {
            this.executionEngine = aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig.invoke(block)
        }
    }
}
