// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details for a notebook execution. The details include information such as the unique ID and status of the notebook execution.
 */
class NotebookExecutionSummary private constructor(builder: Builder) {
    /**
     * The unique identifier of the editor associated with the notebook execution.
     */
    val editorId: kotlin.String? = builder.editorId
    /**
     * The timestamp when notebook execution started.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The unique identifier of the notebook execution.
     */
    val notebookExecutionId: kotlin.String? = builder.notebookExecutionId
    /**
     * The name of the notebook execution.
     */
    val notebookExecutionName: kotlin.String? = builder.notebookExecutionName
    /**
     * The timestamp when notebook execution started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the notebook execution.
     *
     *
     *
     * START_PENDING indicates that the cluster has received the execution
     * request but execution has not begun.
     *
     *
     * STARTING indicates that the execution is starting on the
     * cluster.
     *
     *
     * RUNNING indicates that the execution is being processed by the
     * cluster.
     *
     *
     * FINISHING indicates that execution processing is in the final
     * stages.
     *
     *
     * FINISHED indicates that the execution has completed without
     * error.
     *
     *
     * FAILING indicates that the execution is failing and will not finish
     * successfully.
     *
     *
     * FAILED indicates that the execution failed.
     *
     *
     * STOP_PENDING indicates that the cluster has received a
     * StopNotebookExecution request and the stop is pending.
     *
     *
     * STOPPING indicates that the cluster is in the process of stopping the
     * execution as a result of a StopNotebookExecution request.
     *
     *
     * STOPPED indicates that the execution stopped because of a
     * StopNotebookExecution request.
     */
    val status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.NotebookExecutionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotebookExecutionSummary(")
        append("editorId=$editorId,")
        append("endTime=$endTime,")
        append("notebookExecutionId=$notebookExecutionId,")
        append("notebookExecutionName=$notebookExecutionName,")
        append("startTime=$startTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = editorId?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionId?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotebookExecutionSummary

        if (editorId != other.editorId) return false
        if (endTime != other.endTime) return false
        if (notebookExecutionId != other.notebookExecutionId) return false
        if (notebookExecutionName != other.notebookExecutionName) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.NotebookExecutionSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier of the editor associated with the notebook execution.
         */
        var editorId: kotlin.String? = null
        /**
         * The timestamp when notebook execution started.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the notebook execution.
         */
        var notebookExecutionId: kotlin.String? = null
        /**
         * The name of the notebook execution.
         */
        var notebookExecutionName: kotlin.String? = null
        /**
         * The timestamp when notebook execution started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the notebook execution.
         *
         *
         *
         * START_PENDING indicates that the cluster has received the execution
         * request but execution has not begun.
         *
         *
         * STARTING indicates that the execution is starting on the
         * cluster.
         *
         *
         * RUNNING indicates that the execution is being processed by the
         * cluster.
         *
         *
         * FINISHING indicates that execution processing is in the final
         * stages.
         *
         *
         * FINISHED indicates that the execution has completed without
         * error.
         *
         *
         * FAILING indicates that the execution is failing and will not finish
         * successfully.
         *
         *
         * FAILED indicates that the execution failed.
         *
         *
         * STOP_PENDING indicates that the cluster has received a
         * StopNotebookExecution request and the stop is pending.
         *
         *
         * STOPPING indicates that the cluster is in the process of stopping the
         * execution as a result of a StopNotebookExecution request.
         *
         *
         * STOPPED indicates that the execution stopped because of a
         * StopNotebookExecution request.
         */
        var status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.NotebookExecutionSummary) : this() {
            this.editorId = x.editorId
            this.endTime = x.endTime
            this.notebookExecutionId = x.notebookExecutionId
            this.notebookExecutionName = x.notebookExecutionName
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.NotebookExecutionSummary = NotebookExecutionSummary(this)
    }
}
