// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Placement group configuration for an Amazon EMR cluster. The configuration specifies the
 * placement strategy that can be applied to instance roles during cluster creation.
 * To use this configuration, consider attaching managed policy
 * AmazonElasticMapReducePlacementGroupPolicy to the EMR role.
 */
class PlacementGroupConfig private constructor(builder: Builder) {
    /**
     * Role of the instance in the cluster.
     * Starting with Amazon EMR version 5.23.0, the only supported instance role is
     * MASTER.
     */
    val instanceRole: aws.sdk.kotlin.services.emr.model.InstanceRoleType? = builder.instanceRole
    /**
     * EC2 Placement Group strategy associated with instance role.
     * Starting with Amazon EMR version 5.23.0, the only supported placement strategy is
     * SPREAD for the MASTER instance role.
     */
    val placementStrategy: aws.sdk.kotlin.services.emr.model.PlacementGroupStrategy? = builder.placementStrategy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.PlacementGroupConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlacementGroupConfig(")
        append("instanceRole=$instanceRole,")
        append("placementStrategy=$placementStrategy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceRole?.hashCode() ?: 0
        result = 31 * result + (placementStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlacementGroupConfig

        if (instanceRole != other.instanceRole) return false
        if (placementStrategy != other.placementStrategy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.PlacementGroupConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Role of the instance in the cluster.
         * Starting with Amazon EMR version 5.23.0, the only supported instance role is
         * MASTER.
         */
        var instanceRole: aws.sdk.kotlin.services.emr.model.InstanceRoleType? = null
        /**
         * EC2 Placement Group strategy associated with instance role.
         * Starting with Amazon EMR version 5.23.0, the only supported placement strategy is
         * SPREAD for the MASTER instance role.
         */
        var placementStrategy: aws.sdk.kotlin.services.emr.model.PlacementGroupStrategy? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.PlacementGroupConfig) : this() {
            this.instanceRole = x.instanceRole
            this.placementStrategy = x.placementStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.PlacementGroupConfig = PlacementGroupConfig(this)
    }
}
