// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Input to the RunJobFlow operation.
 */
class RunJobFlowRequest private constructor(builder: Builder) {
    /**
     * A JSON string for selecting additional features.
     */
    val additionalInfo: kotlin.String? = builder.additionalInfo
    /**
     * Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and
     * later, ReleaseLabel is used. To specify a custom AMI, use
     * CustomAmiID.
     */
    val amiVersion: kotlin.String? = builder.amiVersion
    /**
     * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications
     * for Amazon EMR to install and configure when launching the cluster. For a list of
     * applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease
     * Guide.
     */
    val applications: List<Application>? = builder.applications
    /**
     * An IAM role for automatic scaling policies. The default role is
     * EMR_AutoScaling_DefaultRole. The IAM role provides permissions that the
     * automatic scaling feature requires to launch and terminate EC2 instances in an instance
     * group.
     */
    val autoScalingRole: kotlin.String? = builder.autoScalingRole
    /**
     * An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination.
     */
    val autoTerminationPolicy: aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy? = builder.autoTerminationPolicy
    /**
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     */
    val bootstrapActions: List<BootstrapActionConfig>? = builder.bootstrapActions
    /**
     * For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR
     * cluster you are creating.
     */
    val configurations: List<Configuration>? = builder.configurations
    /**
     * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
     * EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2
     * instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom
     * AMI in the Amazon EMR Management Guide. If omitted, the
     * cluster uses the base Linux AMI for the ReleaseLabel specified. For Amazon EMR
     * versions 2.x and 3.x, use AmiVersion instead.
     * For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed
     * Linux AMI in the Amazon Elastic Compute Cloud User Guide for Linux
     * Instances. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux
     * AMI.
     */
    val customAmiId: kotlin.String? = builder.customAmiId
    /**
     * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
     * each EC2 instance. Available in Amazon EMR version 4.x and later.
     */
    val ebsRootVolumeSize: kotlin.Int? = builder.ebsRootVolumeSize
    /**
     * A specification of the number and type of Amazon EC2 instances.
     */
    val instances: aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig? = builder.instances
    /**
     * Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2
     * instances of the cluster assume this role. The default role is
     * EMR_EC2_DefaultRole. In order to use the default role, you must have
     * already created it using the CLI or console.
     */
    val jobFlowRole: kotlin.String? = builder.jobFlowRole
    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a
     * security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication
     * in the Amazon EMR Management Guide.
     */
    val kerberosAttributes: aws.sdk.kotlin.services.emr.model.KerberosAttributes? = builder.kerberosAttributes
    /**
     * The KMS key used for encrypting log files. If a value is not
     * provided, the logs remain encrypted by AES-256. This attribute is only available with
     * Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.
     */
    val logEncryptionKmsKeyId: kotlin.String? = builder.logEncryptionKmsKeyId
    /**
     * The location in Amazon S3 to write the log files of the job flow. If a value is not
     * provided, logs are not created.
     */
    val logUri: kotlin.String? = builder.logUri
    /**
     * The specified managed scaling policy for an Amazon EMR cluster.
     */
    val managedScalingPolicy: aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy? = builder.managedScalingPolicy
    /**
     * The name of the job flow.
     */
    val name: kotlin.String? = builder.name
    /**
     * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
     * Applications.
     *
     * A list of strings that indicates third-party software to use with the job flow that
     * accepts a user argument list. EMR accepts and forwards the argument list to the
     * corresponding installation script as bootstrap action arguments. For more information, see
     * "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide. Supported
     * values are:
     *
     *
     * "mapr-m3" - launch the cluster using MapR M3 Edition.
     *
     * "mapr-m5" - launch the cluster using MapR M5 Edition.
     *
     * "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" -
     * launch the job flow using MapR M3 or M5 Edition respectively.
     *
     * "mapr-m7" - launch the cluster using MapR M7 Edition.
     *
     * "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
     *
     * "hue"- launch the cluster with Hue installed.
     *
     * "spark" - launch the cluster with Apache Spark installed.
     *
     * "ganglia" - launch the cluster with the Ganglia Monitoring System
     * installed.
     */
    val newSupportedProducts: List<SupportedProductConfig>? = builder.newSupportedProducts
    /**
     * The specified placement group configuration for an Amazon EMR cluster.
     */
    val placementGroupConfigs: List<PlacementGroupConfig>? = builder.placementGroupConfigs
    /**
     * The Amazon EMR release label, which determines the version of open-source application
     * packages installed on the cluster. Release labels are in the form emr-x.x.x,
     * where x.x.x is an Amazon EMR release version such as emr-5.14.0. For more
     * information about Amazon EMR release versions and included application versions and
     * features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/. The release
     * label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
     * AmiVersion.
     */
    val releaseLabel: kotlin.String? = builder.releaseLabel
    /**
     * Applies only when CustomAmiID is used. Specifies which updates from the
     * Amazon Linux AMI package repositories to apply automatically when the instance boots using
     * the AMI. If omitted, the default is SECURITY, which indicates that only
     * security updates are applied. If NONE is specified, no updates are applied,
     * and all updates must be applied manually.
     */
    val repoUpgradeOnBoot: aws.sdk.kotlin.services.emr.model.RepoUpgradeOnBoot? = builder.repoUpgradeOnBoot
    /**
     * Specifies the way that individual Amazon EC2 instances terminate when an automatic
     * scale-in activity occurs or an instance group is resized.
     * TERMINATE_AT_INSTANCE_HOUR indicates that Amazon EMR terminates nodes at
     * the instance-hour boundary, regardless of when the request to terminate the instance was
     * submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default
     * for clusters created using that version. TERMINATE_AT_TASK_COMPLETION
     * indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before
     * terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
     * behavior, Amazon EMR removes the least active nodes first and blocks instance termination
     * if it could lead to HDFS corruption. TERMINATE_AT_TASK_COMPLETION available
     * only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR
     * earlier than 5.1.0.
     */
    val scaleDownBehavior: aws.sdk.kotlin.services.emr.model.ScaleDownBehavior? = builder.scaleDownBehavior
    /**
     * The name of a security configuration to apply to the cluster.
     */
    val securityConfiguration: kotlin.String? = builder.securityConfiguration
    /**
     * The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
     * your behalf.
     */
    val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * Specifies the number of steps that can be executed concurrently. The default value is
     * 1. The maximum value is 256.
     */
    val stepConcurrencyLevel: kotlin.Int? = builder.stepConcurrencyLevel
    /**
     * A list of steps to run.
     */
    val steps: List<StepConfig>? = builder.steps
    /**
     * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
     * Applications.
     *
     * A list of strings that indicates third-party software to use. For more information, see
     * the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR
     * Developer Guide. Currently supported values are:
     *
     *
     * "mapr-m3" - launch the job flow using MapR M3 Edition.
     *
     * "mapr-m5" - launch the job flow using MapR M5 Edition.
     */
    val supportedProducts: List<String>? = builder.supportedProducts
    /**
     * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The VisibleToAllUsers parameter is no longer supported. By default, the value is set to true. Setting it to false now has no effect.
     *
     * Set this value to true so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to true for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster command.
     * When set to false, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting in the Amazon EMRManagement Guide.
     */
    val visibleToAllUsers: kotlin.Boolean = builder.visibleToAllUsers

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.RunJobFlowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RunJobFlowRequest(")
        append("additionalInfo=$additionalInfo,")
        append("amiVersion=$amiVersion,")
        append("applications=$applications,")
        append("autoScalingRole=$autoScalingRole,")
        append("autoTerminationPolicy=$autoTerminationPolicy,")
        append("bootstrapActions=$bootstrapActions,")
        append("configurations=$configurations,")
        append("customAmiId=$customAmiId,")
        append("ebsRootVolumeSize=$ebsRootVolumeSize,")
        append("instances=$instances,")
        append("jobFlowRole=$jobFlowRole,")
        append("kerberosAttributes=$kerberosAttributes,")
        append("logEncryptionKmsKeyId=$logEncryptionKmsKeyId,")
        append("logUri=$logUri,")
        append("managedScalingPolicy=$managedScalingPolicy,")
        append("name=$name,")
        append("newSupportedProducts=$newSupportedProducts,")
        append("placementGroupConfigs=$placementGroupConfigs,")
        append("releaseLabel=$releaseLabel,")
        append("repoUpgradeOnBoot=$repoUpgradeOnBoot,")
        append("scaleDownBehavior=$scaleDownBehavior,")
        append("securityConfiguration=$securityConfiguration,")
        append("serviceRole=$serviceRole,")
        append("stepConcurrencyLevel=$stepConcurrencyLevel,")
        append("steps=$steps,")
        append("supportedProducts=$supportedProducts,")
        append("tags=$tags,")
        append("visibleToAllUsers=$visibleToAllUsers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (amiVersion?.hashCode() ?: 0)
        result = 31 * result + (applications?.hashCode() ?: 0)
        result = 31 * result + (autoScalingRole?.hashCode() ?: 0)
        result = 31 * result + (autoTerminationPolicy?.hashCode() ?: 0)
        result = 31 * result + (bootstrapActions?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (customAmiId?.hashCode() ?: 0)
        result = 31 * result + (ebsRootVolumeSize ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (jobFlowRole?.hashCode() ?: 0)
        result = 31 * result + (kerberosAttributes?.hashCode() ?: 0)
        result = 31 * result + (logEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logUri?.hashCode() ?: 0)
        result = 31 * result + (managedScalingPolicy?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (newSupportedProducts?.hashCode() ?: 0)
        result = 31 * result + (placementGroupConfigs?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel?.hashCode() ?: 0)
        result = 31 * result + (repoUpgradeOnBoot?.hashCode() ?: 0)
        result = 31 * result + (scaleDownBehavior?.hashCode() ?: 0)
        result = 31 * result + (securityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (stepConcurrencyLevel ?: 0)
        result = 31 * result + (steps?.hashCode() ?: 0)
        result = 31 * result + (supportedProducts?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (visibleToAllUsers.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RunJobFlowRequest

        if (additionalInfo != other.additionalInfo) return false
        if (amiVersion != other.amiVersion) return false
        if (applications != other.applications) return false
        if (autoScalingRole != other.autoScalingRole) return false
        if (autoTerminationPolicy != other.autoTerminationPolicy) return false
        if (bootstrapActions != other.bootstrapActions) return false
        if (configurations != other.configurations) return false
        if (customAmiId != other.customAmiId) return false
        if (ebsRootVolumeSize != other.ebsRootVolumeSize) return false
        if (instances != other.instances) return false
        if (jobFlowRole != other.jobFlowRole) return false
        if (kerberosAttributes != other.kerberosAttributes) return false
        if (logEncryptionKmsKeyId != other.logEncryptionKmsKeyId) return false
        if (logUri != other.logUri) return false
        if (managedScalingPolicy != other.managedScalingPolicy) return false
        if (name != other.name) return false
        if (newSupportedProducts != other.newSupportedProducts) return false
        if (placementGroupConfigs != other.placementGroupConfigs) return false
        if (releaseLabel != other.releaseLabel) return false
        if (repoUpgradeOnBoot != other.repoUpgradeOnBoot) return false
        if (scaleDownBehavior != other.scaleDownBehavior) return false
        if (securityConfiguration != other.securityConfiguration) return false
        if (serviceRole != other.serviceRole) return false
        if (stepConcurrencyLevel != other.stepConcurrencyLevel) return false
        if (steps != other.steps) return false
        if (supportedProducts != other.supportedProducts) return false
        if (tags != other.tags) return false
        if (visibleToAllUsers != other.visibleToAllUsers) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.RunJobFlowRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A JSON string for selecting additional features.
         */
        var additionalInfo: kotlin.String? = null
        /**
         * Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and
         * later, ReleaseLabel is used. To specify a custom AMI, use
         * CustomAmiID.
         */
        var amiVersion: kotlin.String? = null
        /**
         * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications
         * for Amazon EMR to install and configure when launching the cluster. For a list of
         * applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease
         * Guide.
         */
        var applications: List<Application>? = null
        /**
         * An IAM role for automatic scaling policies. The default role is
         * EMR_AutoScaling_DefaultRole. The IAM role provides permissions that the
         * automatic scaling feature requires to launch and terminate EC2 instances in an instance
         * group.
         */
        var autoScalingRole: kotlin.String? = null
        /**
         * An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination.
         */
        var autoTerminationPolicy: aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy? = null
        /**
         * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         */
        var bootstrapActions: List<BootstrapActionConfig>? = null
        /**
         * For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR
         * cluster you are creating.
         */
        var configurations: List<Configuration>? = null
        /**
         * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
         * EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2
         * instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom
         * AMI in the Amazon EMR Management Guide. If omitted, the
         * cluster uses the base Linux AMI for the ReleaseLabel specified. For Amazon EMR
         * versions 2.x and 3.x, use AmiVersion instead.
         * For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed
         * Linux AMI in the Amazon Elastic Compute Cloud User Guide for Linux
         * Instances. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux
         * AMI.
         */
        var customAmiId: kotlin.String? = null
        /**
         * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
         * each EC2 instance. Available in Amazon EMR version 4.x and later.
         */
        var ebsRootVolumeSize: kotlin.Int? = null
        /**
         * A specification of the number and type of Amazon EC2 instances.
         */
        var instances: aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig? = null
        /**
         * Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2
         * instances of the cluster assume this role. The default role is
         * EMR_EC2_DefaultRole. In order to use the default role, you must have
         * already created it using the CLI or console.
         */
        var jobFlowRole: kotlin.String? = null
        /**
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a
         * security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication
         * in the Amazon EMR Management Guide.
         */
        var kerberosAttributes: aws.sdk.kotlin.services.emr.model.KerberosAttributes? = null
        /**
         * The KMS key used for encrypting log files. If a value is not
         * provided, the logs remain encrypted by AES-256. This attribute is only available with
         * Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.
         */
        var logEncryptionKmsKeyId: kotlin.String? = null
        /**
         * The location in Amazon S3 to write the log files of the job flow. If a value is not
         * provided, logs are not created.
         */
        var logUri: kotlin.String? = null
        /**
         * The specified managed scaling policy for an Amazon EMR cluster.
         */
        var managedScalingPolicy: aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy? = null
        /**
         * The name of the job flow.
         */
        var name: kotlin.String? = null
        /**
         * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
         * Applications.
         *
         * A list of strings that indicates third-party software to use with the job flow that
         * accepts a user argument list. EMR accepts and forwards the argument list to the
         * corresponding installation script as bootstrap action arguments. For more information, see
         * "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide. Supported
         * values are:
         *
         *
         * "mapr-m3" - launch the cluster using MapR M3 Edition.
         *
         * "mapr-m5" - launch the cluster using MapR M5 Edition.
         *
         * "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" -
         * launch the job flow using MapR M3 or M5 Edition respectively.
         *
         * "mapr-m7" - launch the cluster using MapR M7 Edition.
         *
         * "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
         *
         * "hue"- launch the cluster with Hue installed.
         *
         * "spark" - launch the cluster with Apache Spark installed.
         *
         * "ganglia" - launch the cluster with the Ganglia Monitoring System
         * installed.
         */
        var newSupportedProducts: List<SupportedProductConfig>? = null
        /**
         * The specified placement group configuration for an Amazon EMR cluster.
         */
        var placementGroupConfigs: List<PlacementGroupConfig>? = null
        /**
         * The Amazon EMR release label, which determines the version of open-source application
         * packages installed on the cluster. Release labels are in the form emr-x.x.x,
         * where x.x.x is an Amazon EMR release version such as emr-5.14.0. For more
         * information about Amazon EMR release versions and included application versions and
         * features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/. The release
         * label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
         * AmiVersion.
         */
        var releaseLabel: kotlin.String? = null
        /**
         * Applies only when CustomAmiID is used. Specifies which updates from the
         * Amazon Linux AMI package repositories to apply automatically when the instance boots using
         * the AMI. If omitted, the default is SECURITY, which indicates that only
         * security updates are applied. If NONE is specified, no updates are applied,
         * and all updates must be applied manually.
         */
        var repoUpgradeOnBoot: aws.sdk.kotlin.services.emr.model.RepoUpgradeOnBoot? = null
        /**
         * Specifies the way that individual Amazon EC2 instances terminate when an automatic
         * scale-in activity occurs or an instance group is resized.
         * TERMINATE_AT_INSTANCE_HOUR indicates that Amazon EMR terminates nodes at
         * the instance-hour boundary, regardless of when the request to terminate the instance was
         * submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default
         * for clusters created using that version. TERMINATE_AT_TASK_COMPLETION
         * indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before
         * terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either
         * behavior, Amazon EMR removes the least active nodes first and blocks instance termination
         * if it could lead to HDFS corruption. TERMINATE_AT_TASK_COMPLETION available
         * only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR
         * earlier than 5.1.0.
         */
        var scaleDownBehavior: aws.sdk.kotlin.services.emr.model.ScaleDownBehavior? = null
        /**
         * The name of a security configuration to apply to the cluster.
         */
        var securityConfiguration: kotlin.String? = null
        /**
         * The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
         * your behalf.
         */
        var serviceRole: kotlin.String? = null
        /**
         * Specifies the number of steps that can be executed concurrently. The default value is
         * 1. The maximum value is 256.
         */
        var stepConcurrencyLevel: kotlin.Int? = null
        /**
         * A list of steps to run.
         */
        var steps: List<StepConfig>? = null
        /**
         * For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use
         * Applications.
         *
         * A list of strings that indicates third-party software to use. For more information, see
         * the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR
         * Developer Guide. Currently supported values are:
         *
         *
         * "mapr-m3" - launch the job flow using MapR M3 Edition.
         *
         * "mapr-m5" - launch the job flow using MapR M5 Edition.
         */
        var supportedProducts: List<String>? = null
        /**
         * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         */
        var tags: List<Tag>? = null
        /**
         * The VisibleToAllUsers parameter is no longer supported. By default, the value is set to true. Setting it to false now has no effect.
         *
         * Set this value to true so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to true for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster command.
         * When set to false, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting in the Amazon EMRManagement Guide.
         */
        var visibleToAllUsers: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.RunJobFlowRequest) : this() {
            this.additionalInfo = x.additionalInfo
            this.amiVersion = x.amiVersion
            this.applications = x.applications
            this.autoScalingRole = x.autoScalingRole
            this.autoTerminationPolicy = x.autoTerminationPolicy
            this.bootstrapActions = x.bootstrapActions
            this.configurations = x.configurations
            this.customAmiId = x.customAmiId
            this.ebsRootVolumeSize = x.ebsRootVolumeSize
            this.instances = x.instances
            this.jobFlowRole = x.jobFlowRole
            this.kerberosAttributes = x.kerberosAttributes
            this.logEncryptionKmsKeyId = x.logEncryptionKmsKeyId
            this.logUri = x.logUri
            this.managedScalingPolicy = x.managedScalingPolicy
            this.name = x.name
            this.newSupportedProducts = x.newSupportedProducts
            this.placementGroupConfigs = x.placementGroupConfigs
            this.releaseLabel = x.releaseLabel
            this.repoUpgradeOnBoot = x.repoUpgradeOnBoot
            this.scaleDownBehavior = x.scaleDownBehavior
            this.securityConfiguration = x.securityConfiguration
            this.serviceRole = x.serviceRole
            this.stepConcurrencyLevel = x.stepConcurrencyLevel
            this.steps = x.steps
            this.supportedProducts = x.supportedProducts
            this.tags = x.tags
            this.visibleToAllUsers = x.visibleToAllUsers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.RunJobFlowRequest = RunJobFlowRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy] inside the given [block]
         */
        fun autoTerminationPolicy(block: aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy.Builder.() -> kotlin.Unit) {
            this.autoTerminationPolicy = aws.sdk.kotlin.services.emr.model.AutoTerminationPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig] inside the given [block]
         */
        fun instances(block: aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig.Builder.() -> kotlin.Unit) {
            this.instances = aws.sdk.kotlin.services.emr.model.JobFlowInstancesConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.KerberosAttributes] inside the given [block]
         */
        fun kerberosAttributes(block: aws.sdk.kotlin.services.emr.model.KerberosAttributes.Builder.() -> kotlin.Unit) {
            this.kerberosAttributes = aws.sdk.kotlin.services.emr.model.KerberosAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy] inside the given [block]
         */
        fun managedScalingPolicy(block: aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy.Builder.() -> kotlin.Unit) {
            this.managedScalingPolicy = aws.sdk.kotlin.services.emr.model.ManagedScalingPolicy.invoke(block)
        }
    }
}
