// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details for an Amazon EMR Studio session mapping. The details do not include the time
 * the session mapping was last modified.
 */
class SessionMappingSummary private constructor(builder: Builder) {
    /**
     * The time the session mapping was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity
     * Store.
     */
    val identityId: kotlin.String? = builder.identityId
    /**
     * The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName in the Amazon Web Services SSO Identity Store API
     * Reference.
     */
    val identityName: kotlin.String? = builder.identityName
    /**
     * Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
     */
    val identityType: aws.sdk.kotlin.services.emr.model.IdentityType? = builder.identityType
    /**
     * The Amazon Resource Name (ARN) of the session policy associated with the user or
     * group.
     */
    val sessionPolicyArn: kotlin.String? = builder.sessionPolicyArn
    /**
     * The ID of the Amazon EMR Studio.
     */
    val studioId: kotlin.String? = builder.studioId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.SessionMappingSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionMappingSummary(")
        append("creationTime=$creationTime,")
        append("identityId=$identityId,")
        append("identityName=$identityName,")
        append("identityType=$identityType,")
        append("sessionPolicyArn=$sessionPolicyArn,")
        append("studioId=$studioId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (identityId?.hashCode() ?: 0)
        result = 31 * result + (identityName?.hashCode() ?: 0)
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (sessionPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (studioId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionMappingSummary

        if (creationTime != other.creationTime) return false
        if (identityId != other.identityId) return false
        if (identityName != other.identityName) return false
        if (identityType != other.identityType) return false
        if (sessionPolicyArn != other.sessionPolicyArn) return false
        if (studioId != other.studioId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.SessionMappingSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time the session mapping was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity
         * Store.
         */
        var identityId: kotlin.String? = null
        /**
         * The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName in the Amazon Web Services SSO Identity Store API
         * Reference.
         */
        var identityName: kotlin.String? = null
        /**
         * Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.
         */
        var identityType: aws.sdk.kotlin.services.emr.model.IdentityType? = null
        /**
         * The Amazon Resource Name (ARN) of the session policy associated with the user or
         * group.
         */
        var sessionPolicyArn: kotlin.String? = null
        /**
         * The ID of the Amazon EMR Studio.
         */
        var studioId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.SessionMappingSummary) : this() {
            this.creationTime = x.creationTime
            this.identityId = x.identityId
            this.identityName = x.identityName
            this.identityType = x.identityType
            this.sessionPolicyArn = x.sessionPolicyArn
            this.studioId = x.studioId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.SessionMappingSummary = SessionMappingSummary(this)
    }
}
