// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



class StartNotebookExecutionRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the EMR Notebook to use for notebook execution.
     */
    val editorId: kotlin.String? = builder.editorId
    /**
     * Specifies the execution engine (cluster) that runs the notebook execution.
     */
    val executionEngine: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig? = builder.executionEngine
    /**
     * An optional name for the notebook execution.
     */
    val notebookExecutionName: kotlin.String? = builder.notebookExecutionName
    /**
     * The unique identifier of the Amazon EC2 security group to associate with the EMR
     * Notebook for this notebook execution.
     */
    val notebookInstanceSecurityGroupId: kotlin.String? = builder.notebookInstanceSecurityGroupId
    /**
     * Input parameters in JSON format passed to the EMR Notebook at runtime for
     * execution.
     */
    val notebookParams: kotlin.String? = builder.notebookParams
    /**
     * The path and file name of the notebook file for this execution, relative to the path
     * specified for the EMR Notebook. For example, if you specify a path of
     * s3://MyBucket/MyNotebooks when you create an EMR Notebook for a notebook
     * with an ID of e-ABCDEFGHIJK1234567890ABCD (the EditorID of this
     * request), and you specify a RelativePath of
     * my_notebook_executions/notebook_execution.ipynb, the location of the file
     * for the notebook execution is
     * s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb.
     */
    val relativePath: kotlin.String? = builder.relativePath
    /**
     * The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR
     * role) for the notebook execution.
     */
    val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * A list of tags associated with a notebook execution. Tags are user-defined key-value
     * pairs that consist of a required key string with a maximum of 128 characters and an
     * optional value string with a maximum of 256 characters.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartNotebookExecutionRequest(")
        append("editorId=$editorId,")
        append("executionEngine=$executionEngine,")
        append("notebookExecutionName=$notebookExecutionName,")
        append("notebookInstanceSecurityGroupId=$notebookInstanceSecurityGroupId,")
        append("notebookParams=$notebookParams,")
        append("relativePath=$relativePath,")
        append("serviceRole=$serviceRole,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = editorId?.hashCode() ?: 0
        result = 31 * result + (executionEngine?.hashCode() ?: 0)
        result = 31 * result + (notebookExecutionName?.hashCode() ?: 0)
        result = 31 * result + (notebookInstanceSecurityGroupId?.hashCode() ?: 0)
        result = 31 * result + (notebookParams?.hashCode() ?: 0)
        result = 31 * result + (relativePath?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartNotebookExecutionRequest

        if (editorId != other.editorId) return false
        if (executionEngine != other.executionEngine) return false
        if (notebookExecutionName != other.notebookExecutionName) return false
        if (notebookInstanceSecurityGroupId != other.notebookInstanceSecurityGroupId) return false
        if (notebookParams != other.notebookParams) return false
        if (relativePath != other.relativePath) return false
        if (serviceRole != other.serviceRole) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier of the EMR Notebook to use for notebook execution.
         */
        var editorId: kotlin.String? = null
        /**
         * Specifies the execution engine (cluster) that runs the notebook execution.
         */
        var executionEngine: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig? = null
        /**
         * An optional name for the notebook execution.
         */
        var notebookExecutionName: kotlin.String? = null
        /**
         * The unique identifier of the Amazon EC2 security group to associate with the EMR
         * Notebook for this notebook execution.
         */
        var notebookInstanceSecurityGroupId: kotlin.String? = null
        /**
         * Input parameters in JSON format passed to the EMR Notebook at runtime for
         * execution.
         */
        var notebookParams: kotlin.String? = null
        /**
         * The path and file name of the notebook file for this execution, relative to the path
         * specified for the EMR Notebook. For example, if you specify a path of
         * s3://MyBucket/MyNotebooks when you create an EMR Notebook for a notebook
         * with an ID of e-ABCDEFGHIJK1234567890ABCD (the EditorID of this
         * request), and you specify a RelativePath of
         * my_notebook_executions/notebook_execution.ipynb, the location of the file
         * for the notebook execution is
         * s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb.
         */
        var relativePath: kotlin.String? = null
        /**
         * The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR
         * role) for the notebook execution.
         */
        var serviceRole: kotlin.String? = null
        /**
         * A list of tags associated with a notebook execution. Tags are user-defined key-value
         * pairs that consist of a required key string with a maximum of 128 characters and an
         * optional value string with a maximum of 256 characters.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest) : this() {
            this.editorId = x.editorId
            this.executionEngine = x.executionEngine
            this.notebookExecutionName = x.notebookExecutionName
            this.notebookInstanceSecurityGroupId = x.notebookInstanceSecurityGroupId
            this.notebookParams = x.notebookParams
            this.relativePath = x.relativePath
            this.serviceRole = x.serviceRole
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest = StartNotebookExecutionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig] inside the given [block]
         */
        fun executionEngine(block: aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig.Builder.() -> kotlin.Unit) {
            this.executionEngine = aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig.invoke(block)
        }
    }
}
