// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * This represents a step in a cluster.
 */
class Step private constructor(builder: Builder) {
    /**
     * The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
     * CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility.
     * We recommend using TERMINATE_CLUSTER instead.
     * If a cluster's StepConcurrencyLevel is greater than 1, do not use AddJobFlowSteps to submit a step with this parameter set to CANCEL_AND_WAIT or TERMINATE_CLUSTER. The step is not submitted and the action fails with a message that the ActionOnFailure setting is not valid.
     * If you change a cluster's StepConcurrencyLevel to be greater than 1 while a step is running, the ActionOnFailure parameter may not behave as you expect. In this case, for a step that fails with this parameter set to CANCEL_AND_WAIT, pending steps and the running step are not canceled; for a step that fails with this parameter set to TERMINATE_CLUSTER, the cluster does not terminate.
     */
    val actionOnFailure: aws.sdk.kotlin.services.emr.model.ActionOnFailure? = builder.actionOnFailure
    /**
     * The Hadoop job configuration of the cluster step.
     */
    val config: aws.sdk.kotlin.services.emr.model.HadoopStepConfig? = builder.config
    /**
     * The identifier of the cluster step.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the cluster step.
     */
    val name: kotlin.String? = builder.name
    /**
     * The current execution status details of the cluster step.
     */
    val status: aws.sdk.kotlin.services.emr.model.StepStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.Step = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Step(")
        append("actionOnFailure=$actionOnFailure,")
        append("config=$config,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionOnFailure?.hashCode() ?: 0
        result = 31 * result + (config?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Step

        if (actionOnFailure != other.actionOnFailure) return false
        if (config != other.config) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.Step = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
         * CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is provided for backward compatibility.
         * We recommend using TERMINATE_CLUSTER instead.
         * If a cluster's StepConcurrencyLevel is greater than 1, do not use AddJobFlowSteps to submit a step with this parameter set to CANCEL_AND_WAIT or TERMINATE_CLUSTER. The step is not submitted and the action fails with a message that the ActionOnFailure setting is not valid.
         * If you change a cluster's StepConcurrencyLevel to be greater than 1 while a step is running, the ActionOnFailure parameter may not behave as you expect. In this case, for a step that fails with this parameter set to CANCEL_AND_WAIT, pending steps and the running step are not canceled; for a step that fails with this parameter set to TERMINATE_CLUSTER, the cluster does not terminate.
         */
        var actionOnFailure: aws.sdk.kotlin.services.emr.model.ActionOnFailure? = null
        /**
         * The Hadoop job configuration of the cluster step.
         */
        var config: aws.sdk.kotlin.services.emr.model.HadoopStepConfig? = null
        /**
         * The identifier of the cluster step.
         */
        var id: kotlin.String? = null
        /**
         * The name of the cluster step.
         */
        var name: kotlin.String? = null
        /**
         * The current execution status details of the cluster step.
         */
        var status: aws.sdk.kotlin.services.emr.model.StepStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.Step) : this() {
            this.actionOnFailure = x.actionOnFailure
            this.config = x.config
            this.id = x.id
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.Step = Step(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.HadoopStepConfig] inside the given [block]
         */
        fun config(block: aws.sdk.kotlin.services.emr.model.HadoopStepConfig.Builder.() -> kotlin.Unit) {
            this.config = aws.sdk.kotlin.services.emr.model.HadoopStepConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.StepStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.emr.model.StepStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.emr.model.StepStatus.invoke(block)
        }
    }
}
