// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration
import aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfigurationMetadata
import aws.sdk.kotlin.services.emr.model.EmrException
import aws.sdk.kotlin.services.emr.model.GetBlockPublicAccessConfigurationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetBlockPublicAccessConfigurationOperationDeserializer: HttpDeserialize<GetBlockPublicAccessConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBlockPublicAccessConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwGetBlockPublicAccessConfigurationError(context, response)
        }
        val builder = GetBlockPublicAccessConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBlockPublicAccessConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetBlockPublicAccessConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EmrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EmrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBlockPublicAccessConfigurationOperationBody(builder: GetBlockPublicAccessConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOCKPUBLICACCESSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BlockPublicAccessConfiguration"))
    val BLOCKPUBLICACCESSCONFIGURATIONMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BlockPublicAccessConfigurationMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCKPUBLICACCESSCONFIGURATION_DESCRIPTOR)
        field(BLOCKPUBLICACCESSCONFIGURATIONMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCKPUBLICACCESSCONFIGURATION_DESCRIPTOR.index -> builder.blockPublicAccessConfiguration = deserializeBlockPublicAccessConfigurationDocument(deserializer)
                BLOCKPUBLICACCESSCONFIGURATIONMETADATA_DESCRIPTOR.index -> builder.blockPublicAccessConfigurationMetadata = deserializeBlockPublicAccessConfigurationMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
