// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.transform

import aws.sdk.kotlin.services.emr.model.ClusterState
import aws.sdk.kotlin.services.emr.model.ListClustersRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListClustersOperationSerializer: HttpSerialize<ListClustersRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListClustersRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeListClustersOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        return builder
    }
}

private fun serializeListClustersOperationBody(context: ExecutionContext, input: ListClustersRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLUSTERSTATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ClusterStates"))
    val CREATEDAFTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAfter"))
    val CREATEDBEFORE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedBefore"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERSTATES_DESCRIPTOR)
        field(CREATEDAFTER_DESCRIPTOR)
        field(CREATEDBEFORE_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.clusterStates != null) {
            listField(CLUSTERSTATES_DESCRIPTOR) {
                for (el0 in input.clusterStates) {
                    serializeString(el0.value)
                }
            }
        }
        input.createdAfter?.let { field(CREATEDAFTER_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.createdBefore?.let { field(CREATEDBEFORE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.marker?.let { field(MARKER_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
