// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.waiters

import aws.sdk.kotlin.services.emr.EmrClient
import aws.sdk.kotlin.services.emr.model.DescribeClusterRequest
import aws.sdk.kotlin.services.emr.model.DescribeClusterResponse
import aws.sdk.kotlin.services.emr.model.DescribeStepRequest
import aws.sdk.kotlin.services.emr.model.DescribeStepResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds
import kotlin.time.Duration.Companion.seconds


suspend fun EmrClient.waitUntilClusterRunning(request: DescribeClusterRequest): Outcome<DescribeClusterResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxTime = 300.seconds, maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeClusterRequest, DescribeClusterResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cluster = it?.cluster
            val status = cluster?.status
            val state = status?.state
            state?.toString() == "RUNNING"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cluster = it?.cluster
            val status = cluster?.status
            val state = status?.state
            state?.toString() == "WAITING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it?.cluster
            val status = cluster?.status
            val state = status?.state
            state?.toString() == "TERMINATING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it?.cluster
            val status = cluster?.status
            val state = status?.state
            state?.toString() == "TERMINATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it?.cluster
            val status = cluster?.status
            val state = status?.state
            state?.toString() == "TERMINATED_WITH_ERRORS"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCluster(request) }
}

suspend fun EmrClient.waitUntilClusterRunning(block: DescribeClusterRequest.Builder.() -> Unit): Outcome<DescribeClusterResponse> =
    waitUntilClusterRunning(DescribeClusterRequest.Builder().apply(block).build())

suspend fun EmrClient.waitUntilClusterTerminated(request: DescribeClusterRequest): Outcome<DescribeClusterResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxTime = 300.seconds, maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeClusterRequest, DescribeClusterResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cluster = it?.cluster
            val status = cluster?.status
            val state = status?.state
            state?.toString() == "TERMINATED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cluster = it?.cluster
            val status = cluster?.status
            val state = status?.state
            state?.toString() == "TERMINATED_WITH_ERRORS"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCluster(request) }
}

suspend fun EmrClient.waitUntilClusterTerminated(block: DescribeClusterRequest.Builder.() -> Unit): Outcome<DescribeClusterResponse> =
    waitUntilClusterTerminated(DescribeClusterRequest.Builder().apply(block).build())

suspend fun EmrClient.waitUntilStepComplete(request: DescribeStepRequest): Outcome<DescribeStepResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxTime = 300.seconds, maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeStepRequest, DescribeStepResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val step = it?.step
            val status = step?.status
            val state = status?.state
            state?.toString() == "COMPLETED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val step = it?.step
            val status = step?.status
            val state = status?.state
            state?.toString() == "FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val step = it?.step
            val status = step?.status
            val state = status?.state
            state?.toString() == "CANCELLED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStep(request) }
}

suspend fun EmrClient.waitUntilStepComplete(block: DescribeStepRequest.Builder.() -> Unit): Outcome<DescribeStepResponse> =
    waitUntilStepComplete(DescribeStepRequest.Builder().apply(block).build())
