// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.emr.model.*
import aws.sdk.kotlin.services.emr.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "EMR"
const val ServiceApiVersion: String = "2009-03-31"
const val SdkVersion: String = "0.17.0-beta"

internal class DefaultEmrClient(override val config: EmrClient.Config) : EmrClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds an instance fleet to a running cluster.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.
     */
    override suspend fun addInstanceFleet(input: AddInstanceFleetRequest): AddInstanceFleetResponse {
        val op = SdkHttpOperation.build<AddInstanceFleetRequest, AddInstanceFleetResponse> {
            serializer = AddInstanceFleetOperationSerializer()
            deserializer = AddInstanceFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddInstanceFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more instance groups to a running cluster.
     */
    override suspend fun addInstanceGroups(input: AddInstanceGroupsRequest): AddInstanceGroupsResponse {
        val op = SdkHttpOperation.build<AddInstanceGroupsRequest, AddInstanceGroupsResponse> {
            serializer = AddInstanceGroupsOperationSerializer()
            deserializer = AddInstanceGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddInstanceGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.
     *
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop. For more information on how to do this, see [Add More than 256 Steps to a Cluster](https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html) in the *Amazon EMR Management Guide*.
     *
     * A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each step is performed by the main function of the main class of the JAR file. The main class can be specified either in the manifest of the JAR or by using the MainFunction parameter of the step.
     *
     * Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run successfully.
     *
     * You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or WAITING.
     *
     * The string values passed into `HadoopJarStep` object cannot exceed a total of 10240 characters.
     */
    override suspend fun addJobFlowSteps(input: AddJobFlowStepsRequest): AddJobFlowStepsResponse {
        val op = SdkHttpOperation.build<AddJobFlowStepsRequest, AddJobFlowStepsResponse> {
            serializer = AddJobFlowStepsOperationSerializer()
            deserializer = AddJobFlowStepsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddJobFlowSteps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see [Tag Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializer = AddTagsOperationSerializer()
            deserializer = AddTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a `PENDING` or `RUNNING` state. In earlier versions of Amazon EMR, you can only cancel steps that are in a `PENDING` state.
     */
    override suspend fun cancelSteps(input: CancelStepsRequest): CancelStepsResponse {
        val op = SdkHttpOperation.build<CancelStepsRequest, CancelStepsResponse> {
            serializer = CancelStepsOperationSerializer()
            deserializer = CancelStepsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelSteps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a security configuration, which is stored in the service and can be specified when a cluster is created.
     */
    override suspend fun createSecurityConfiguration(input: CreateSecurityConfigurationRequest): CreateSecurityConfigurationResponse {
        val op = SdkHttpOperation.build<CreateSecurityConfigurationRequest, CreateSecurityConfigurationResponse> {
            serializer = CreateSecurityConfigurationOperationSerializer()
            deserializer = CreateSecurityConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSecurityConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon EMR Studio.
     */
    override suspend fun createStudio(input: CreateStudioRequest): CreateStudioResponse {
        val op = SdkHttpOperation.build<CreateStudioRequest, CreateStudioResponse> {
            serializer = CreateStudioOperationSerializer()
            deserializer = CreateStudioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStudio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Maps a user or group to the Amazon EMR Studio specified by `StudioId`, and applies a session policy to refine Studio permissions for that user or group. Use `CreateStudioSessionMapping` to assign users to a Studio when you use Amazon Web Services SSO authentication. For instructions on how to assign users to a Studio when you use IAM authentication, see [Assign a user or group to your EMR Studio](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups).
     */
    override suspend fun createStudioSessionMapping(input: CreateStudioSessionMappingRequest): CreateStudioSessionMappingResponse {
        val op = SdkHttpOperation.build<CreateStudioSessionMappingRequest, CreateStudioSessionMappingResponse> {
            serializer = CreateStudioSessionMappingOperationSerializer()
            deserializer = CreateStudioSessionMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStudioSessionMapping"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a security configuration.
     */
    override suspend fun deleteSecurityConfiguration(input: DeleteSecurityConfigurationRequest): DeleteSecurityConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteSecurityConfigurationRequest, DeleteSecurityConfigurationResponse> {
            serializer = DeleteSecurityConfigurationOperationSerializer()
            deserializer = DeleteSecurityConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSecurityConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an Amazon EMR Studio from the Studio metadata store.
     */
    override suspend fun deleteStudio(input: DeleteStudioRequest): DeleteStudioResponse {
        val op = SdkHttpOperation.build<DeleteStudioRequest, DeleteStudioResponse> {
            serializer = DeleteStudioOperationSerializer()
            deserializer = DeleteStudioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStudio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a user or group from an Amazon EMR Studio.
     */
    override suspend fun deleteStudioSessionMapping(input: DeleteStudioSessionMappingRequest): DeleteStudioSessionMappingResponse {
        val op = SdkHttpOperation.build<DeleteStudioSessionMappingRequest, DeleteStudioSessionMappingResponse> {
            serializer = DeleteStudioSessionMappingOperationSerializer()
            deserializer = DeleteStudioSessionMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStudioSessionMapping"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.
     */
    override suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse {
        val op = SdkHttpOperation.build<DescribeClusterRequest, DescribeClusterResponse> {
            serializer = DescribeClusterOperationSerializer()
            deserializer = DescribeClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This API is no longer supported and will eventually be removed. We recommend you use ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and ListBootstrapActions instead.
     *
     * DescribeJobFlows returns a list of job flows that match all of the supplied parameters. The parameters can include a list of job flow IDs, job flow states, and restrictions on job flow creation date and time.
     *
     * Regardless of supplied parameters, only job flows created within the last two months are returned.
     *
     * If no parameters are supplied, then job flows matching either of the following criteria are returned:
     * + Job flows created and completed in the last two weeks
     * +  Job flows created within the last two months that are in one of the following states: `RUNNING`, `WAITING`, `SHUTTING_DOWN`, `STARTING`
     *
     * Amazon EMR can return a maximum of 512 job flow descriptions.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeJobFlows(input: DescribeJobFlowsRequest): DescribeJobFlowsResponse {
        val op = SdkHttpOperation.build<DescribeJobFlowsRequest, DescribeJobFlowsResponse> {
            serializer = DescribeJobFlowsOperationSerializer()
            deserializer = DescribeJobFlowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeJobFlows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides details of a notebook execution.
     */
    override suspend fun describeNotebookExecution(input: DescribeNotebookExecutionRequest): DescribeNotebookExecutionResponse {
        val op = SdkHttpOperation.build<DescribeNotebookExecutionRequest, DescribeNotebookExecutionResponse> {
            serializer = DescribeNotebookExecutionOperationSerializer()
            deserializer = DescribeNotebookExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNotebookExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides EMR release label details, such as releases available the region where the API request is run, and the available applications for a specific EMR release label. Can also list EMR release versions that support a specified version of Spark.
     */
    override suspend fun describeReleaseLabel(input: DescribeReleaseLabelRequest): DescribeReleaseLabelResponse {
        val op = SdkHttpOperation.build<DescribeReleaseLabelRequest, DescribeReleaseLabelResponse> {
            serializer = DescribeReleaseLabelOperationSerializer()
            deserializer = DescribeReleaseLabelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReleaseLabel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides the details of a security configuration by returning the configuration JSON.
     */
    override suspend fun describeSecurityConfiguration(input: DescribeSecurityConfigurationRequest): DescribeSecurityConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeSecurityConfigurationRequest, DescribeSecurityConfigurationResponse> {
            serializer = DescribeSecurityConfigurationOperationSerializer()
            deserializer = DescribeSecurityConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSecurityConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides more detail about the cluster step.
     */
    override suspend fun describeStep(input: DescribeStepRequest): DescribeStepResponse {
        val op = SdkHttpOperation.build<DescribeStepRequest, DescribeStepResponse> {
            serializer = DescribeStepOperationSerializer()
            deserializer = DescribeStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStep"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.
     */
    override suspend fun describeStudio(input: DescribeStudioRequest): DescribeStudioResponse {
        val op = SdkHttpOperation.build<DescribeStudioRequest, DescribeStudioResponse> {
            serializer = DescribeStudioOperationSerializer()
            deserializer = DescribeStudioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStudio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the auto-termination policy for an Amazon EMR cluster.
     */
    override suspend fun getAutoTerminationPolicy(input: GetAutoTerminationPolicyRequest): GetAutoTerminationPolicyResponse {
        val op = SdkHttpOperation.build<GetAutoTerminationPolicyRequest, GetAutoTerminationPolicyResponse> {
            serializer = GetAutoTerminationPolicyOperationSerializer()
            deserializer = GetAutoTerminationPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAutoTerminationPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see [Configure Block Public Access for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html) in the *Amazon EMR Management Guide*.
     */
    override suspend fun getBlockPublicAccessConfiguration(input: GetBlockPublicAccessConfigurationRequest): GetBlockPublicAccessConfigurationResponse {
        val op = SdkHttpOperation.build<GetBlockPublicAccessConfigurationRequest, GetBlockPublicAccessConfigurationResponse> {
            serializer = GetBlockPublicAccessConfigurationOperationSerializer()
            deserializer = GetBlockPublicAccessConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBlockPublicAccessConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Fetches the attached managed scaling policy for an Amazon EMR cluster.
     */
    override suspend fun getManagedScalingPolicy(input: GetManagedScalingPolicyRequest): GetManagedScalingPolicyResponse {
        val op = SdkHttpOperation.build<GetManagedScalingPolicyRequest, GetManagedScalingPolicyResponse> {
            serializer = GetManagedScalingPolicyOperationSerializer()
            deserializer = GetManagedScalingPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetManagedScalingPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).
     */
    override suspend fun getStudioSessionMapping(input: GetStudioSessionMappingRequest): GetStudioSessionMappingResponse {
        val op = SdkHttpOperation.build<GetStudioSessionMappingRequest, GetStudioSessionMappingResponse> {
            serializer = GetStudioSessionMappingOperationSerializer()
            deserializer = GetStudioSessionMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetStudioSessionMapping"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information about the bootstrap actions associated with a cluster.
     */
    override suspend fun listBootstrapActions(input: ListBootstrapActionsRequest): ListBootstrapActionsResponse {
        val op = SdkHttpOperation.build<ListBootstrapActionsRequest, ListBootstrapActionsResponse> {
            serializer = ListBootstrapActionsOperationSerializer()
            deserializer = ListBootstrapActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBootstrapActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the cluster list across multiple ListClusters calls.
     */
    override suspend fun listClusters(input: ListClustersRequest): ListClustersResponse {
        val op = SdkHttpOperation.build<ListClustersRequest, ListClustersResponse> {
            serializer = ListClustersOperationSerializer()
            deserializer = ListClustersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListClusters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all available details about the instance fleets in a cluster.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     */
    override suspend fun listInstanceFleets(input: ListInstanceFleetsRequest): ListInstanceFleetsResponse {
        val op = SdkHttpOperation.build<ListInstanceFleetsRequest, ListInstanceFleetsResponse> {
            serializer = ListInstanceFleetsOperationSerializer()
            deserializer = ListInstanceFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInstanceFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides all available details about the instance groups in a cluster.
     */
    override suspend fun listInstanceGroups(input: ListInstanceGroupsRequest): ListInstanceGroupsResponse {
        val op = SdkHttpOperation.build<ListInstanceGroupsRequest, ListInstanceGroupsResponse> {
            serializer = ListInstanceGroupsOperationSerializer()
            deserializer = ListInstanceGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInstanceGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.
     */
    override suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse {
        val op = SdkHttpOperation.build<ListInstancesRequest, ListInstancesResponse> {
            serializer = ListInstancesOperationSerializer()
            deserializer = ListInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status, time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a longer notebook execution list across multiple `ListNotebookExecution` calls.
     */
    override suspend fun listNotebookExecutions(input: ListNotebookExecutionsRequest): ListNotebookExecutionsResponse {
        val op = SdkHttpOperation.build<ListNotebookExecutionsRequest, ListNotebookExecutionsResponse> {
            serializer = ListNotebookExecutionsOperationSerializer()
            deserializer = ListNotebookExecutionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNotebookExecutions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves release labels of EMR services in the region where the API is called.
     */
    override suspend fun listReleaseLabels(input: ListReleaseLabelsRequest): ListReleaseLabelsResponse {
        val op = SdkHttpOperation.build<ListReleaseLabelsRequest, ListReleaseLabelsResponse> {
            serializer = ListReleaseLabelsOperationSerializer()
            deserializer = ListReleaseLabelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListReleaseLabels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the security configurations visible to this account, providing their creation dates and times, and their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple ListSecurityConfigurations calls.
     */
    override suspend fun listSecurityConfigurations(input: ListSecurityConfigurationsRequest): ListSecurityConfigurationsResponse {
        val op = SdkHttpOperation.build<ListSecurityConfigurationsRequest, ListSecurityConfigurationsResponse> {
            serializer = ListSecurityConfigurationsOperationSerializer()
            deserializer = ListSecurityConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSecurityConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of steps for the cluster in reverse order unless you specify `stepIds` with the request or filter by `StepStates`. You can specify a maximum of 10 `stepIDs`. The CLI automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the CLI, specify a `Marker`, which is a pagination token that indicates the next set of steps to retrieve.
     */
    override suspend fun listSteps(input: ListStepsRequest): ListStepsResponse {
        val op = SdkHttpOperation.build<ListStepsRequest, ListStepsResponse> {
            serializer = ListStepsOperationSerializer()
            deserializer = ListStepsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSteps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all user or group session mappings for the Amazon EMR Studio specified by `StudioId`.
     */
    override suspend fun listStudioSessionMappings(input: ListStudioSessionMappingsRequest): ListStudioSessionMappingsResponse {
        val op = SdkHttpOperation.build<ListStudioSessionMappingsRequest, ListStudioSessionMappingsResponse> {
            serializer = ListStudioSessionMappingsOperationSerializer()
            deserializer = ListStudioSessionMappingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStudioSessionMappings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes details such as ID, Studio Access URL, and creation time for each Studio.
     */
    override suspend fun listStudios(input: ListStudiosRequest): ListStudiosResponse {
        val op = SdkHttpOperation.build<ListStudiosRequest, ListStudiosResponse> {
            serializer = ListStudiosOperationSerializer()
            deserializer = ListStudiosOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStudios"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.
     */
    override suspend fun modifyCluster(input: ModifyClusterRequest): ModifyClusterResponse {
        val op = SdkHttpOperation.build<ModifyClusterRequest, ModifyClusterResponse> {
            serializer = ModifyClusterOperationSerializer()
            deserializer = ModifyClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     */
    override suspend fun modifyInstanceFleet(input: ModifyInstanceFleetRequest): ModifyInstanceFleetResponse {
        val op = SdkHttpOperation.build<ModifyInstanceFleetRequest, ModifyInstanceFleetResponse> {
            serializer = ModifyInstanceFleetOperationSerializer()
            deserializer = ModifyInstanceFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyInstanceFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input parameters include the new target instance count for the group and the instance group ID. The call will either succeed or fail atomically.
     */
    override suspend fun modifyInstanceGroups(input: ModifyInstanceGroupsRequest): ModifyInstanceGroupsResponse {
        val op = SdkHttpOperation.build<ModifyInstanceGroupsRequest, ModifyInstanceGroupsResponse> {
            serializer = ModifyInstanceGroupsOperationSerializer()
            deserializer = ModifyInstanceGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyInstanceGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric.
     */
    override suspend fun putAutoScalingPolicy(input: PutAutoScalingPolicyRequest): PutAutoScalingPolicyResponse {
        val op = SdkHttpOperation.build<PutAutoScalingPolicyRequest, PutAutoScalingPolicyResponse> {
            serializer = PutAutoScalingPolicyOperationSerializer()
            deserializer = PutAutoScalingPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAutoScalingPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see [Using an auto-termination policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html).
     *
     * Creates or updates an auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see [Control cluster termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html).
     */
    override suspend fun putAutoTerminationPolicy(input: PutAutoTerminationPolicyRequest): PutAutoTerminationPolicyResponse {
        val op = SdkHttpOperation.build<PutAutoTerminationPolicyRequest, PutAutoTerminationPolicyResponse> {
            serializer = PutAutoTerminationPolicyOperationSerializer()
            deserializer = PutAutoTerminationPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAutoTerminationPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see [Configure Block Public Access for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html) in the *Amazon EMR Management Guide*.
     */
    override suspend fun putBlockPublicAccessConfiguration(input: PutBlockPublicAccessConfigurationRequest): PutBlockPublicAccessConfigurationResponse {
        val op = SdkHttpOperation.build<PutBlockPublicAccessConfigurationRequest, PutBlockPublicAccessConfigurationResponse> {
            serializer = PutBlockPublicAccessConfigurationOperationSerializer()
            deserializer = PutBlockPublicAccessConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutBlockPublicAccessConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     */
    override suspend fun putManagedScalingPolicy(input: PutManagedScalingPolicyRequest): PutManagedScalingPolicyResponse {
        val op = SdkHttpOperation.build<PutManagedScalingPolicyRequest, PutManagedScalingPolicyResponse> {
            serializer = PutManagedScalingPolicyOperationSerializer()
            deserializer = PutManagedScalingPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutManagedScalingPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an automatic scaling policy from a specified instance group within an EMR cluster.
     */
    override suspend fun removeAutoScalingPolicy(input: RemoveAutoScalingPolicyRequest): RemoveAutoScalingPolicyResponse {
        val op = SdkHttpOperation.build<RemoveAutoScalingPolicyRequest, RemoveAutoScalingPolicyResponse> {
            serializer = RemoveAutoScalingPolicyOperationSerializer()
            deserializer = RemoveAutoScalingPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveAutoScalingPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an auto-termination policy from an Amazon EMR cluster.
     */
    override suspend fun removeAutoTerminationPolicy(input: RemoveAutoTerminationPolicyRequest): RemoveAutoTerminationPolicyResponse {
        val op = SdkHttpOperation.build<RemoveAutoTerminationPolicyRequest, RemoveAutoTerminationPolicyResponse> {
            serializer = RemoveAutoTerminationPolicyOperationSerializer()
            deserializer = RemoveAutoTerminationPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveAutoTerminationPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a managed scaling policy from a specified EMR cluster.
     */
    override suspend fun removeManagedScalingPolicy(input: RemoveManagedScalingPolicyRequest): RemoveManagedScalingPolicyResponse {
        val op = SdkHttpOperation.build<RemoveManagedScalingPolicyRequest, RemoveManagedScalingPolicyResponse> {
            serializer = RemoveManagedScalingPolicyOperationSerializer()
            deserializer = RemoveManagedScalingPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveManagedScalingPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see [Tag Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
     *
     * The following example removes the stack tag with value Prod from a cluster:
     */
    override suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse {
        val op = SdkHttpOperation.build<RemoveTagsRequest, RemoveTagsResponse> {
            serializer = RemoveTagsOperationSerializer()
            deserializer = RemoveTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last step of the job flow to store results in Amazon S3. If the JobFlowInstancesConfig`KeepJobFlowAliveWhenNoSteps` parameter is set to `TRUE`, the cluster transitions to the WAITING state rather than shutting down after the steps have completed.
     *
     * For additional protection, you can set the JobFlowInstancesConfig`TerminationProtected` parameter to `TRUE` to lock the cluster and prevent it from being terminated by API call, user intervention, or in the event of a job flow error.
     *
     * A maximum of 256 steps are allowed in each job flow.
     *
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using the SSH shell to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop. For more information on how to do this, see [Add More than 256 Steps to a Cluster](https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html) in the *Amazon EMR Management Guide*.
     *
     * For long running clusters, we recommend that you periodically store your results.
     *
     * The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. The RunJobFlow request can contain InstanceFleets parameters or InstanceGroups parameters, but not both.
     */
    override suspend fun runJobFlow(input: RunJobFlowRequest): RunJobFlowResponse {
        val op = SdkHttpOperation.build<RunJobFlowRequest, RunJobFlowResponse> {
            serializer = RunJobFlowOperationSerializer()
            deserializer = RunJobFlowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RunJobFlow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful completion of the job flow. Calling `SetTerminationProtection` on a cluster is similar to calling the Amazon EC2 `DisableAPITermination` API on all EC2 instances in a cluster.
     *
     * `SetTerminationProtection` is used to prevent accidental termination of a cluster and to ensure that in the event of an error, the instances persist so that you can recover any data stored in their ephemeral instance storage.
     *
     *  To terminate a cluster that has been locked by setting `SetTerminationProtection` to `true`, you must first unlock the job flow by a subsequent call to `SetTerminationProtection` in which you set the value to `false`.
     *
     *  For more information, see[Managing Cluster Termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html) in the *Amazon EMR Management Guide*.
     */
    override suspend fun setTerminationProtection(input: SetTerminationProtectionRequest): SetTerminationProtectionResponse {
        val op = SdkHttpOperation.build<SetTerminationProtectionRequest, SetTerminationProtectionResponse> {
            serializer = SetTerminationProtectionOperationSerializer()
            deserializer = SetTerminationProtectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetTerminationProtection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your account. To restrict cluster access using an IAM policy, see [Identity and Access Management for EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html).
     *
     * Sets the Cluster$VisibleToAllUsers value for an EMR cluster. When `true`, IAM principals in the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When `false`, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions on the cluster, regardless of IAM permissions policies attached to other IAM principals.
     *
     * This action works on running clusters. When you create a cluster, use the RunJobFlowInput$VisibleToAllUsers parameter.
     *
     * For more information, see [Understanding the EMR Cluster VisibleToAllUsers Setting](https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users) in the *Amazon EMRManagement Guide*.
     */
    override suspend fun setVisibleToAllUsers(input: SetVisibleToAllUsersRequest): SetVisibleToAllUsersResponse {
        val op = SdkHttpOperation.build<SetVisibleToAllUsersRequest, SetVisibleToAllUsersResponse> {
            serializer = SetVisibleToAllUsersOperationSerializer()
            deserializer = SetVisibleToAllUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetVisibleToAllUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a notebook execution.
     */
    override suspend fun startNotebookExecution(input: StartNotebookExecutionRequest): StartNotebookExecutionResponse {
        val op = SdkHttpOperation.build<StartNotebookExecutionRequest, StartNotebookExecutionResponse> {
            serializer = StartNotebookExecutionOperationSerializer()
            deserializer = StartNotebookExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartNotebookExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a notebook execution.
     */
    override suspend fun stopNotebookExecution(input: StopNotebookExecutionRequest): StopNotebookExecutionResponse {
        val op = SdkHttpOperation.build<StopNotebookExecutionRequest, StopNotebookExecutionResponse> {
            serializer = StopNotebookExecutionOperationSerializer()
            deserializer = StopNotebookExecutionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopNotebookExecution"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.
     *
     * The maximum number of clusters allowed is 10. The call to `TerminateJobFlows` is asynchronous. Depending on the configuration of the cluster, it may take up to 1-5 minutes for the cluster to completely terminate and release allocated resources, such as Amazon EC2 instances.
     */
    override suspend fun terminateJobFlows(input: TerminateJobFlowsRequest): TerminateJobFlowsResponse {
        val op = SdkHttpOperation.build<TerminateJobFlowsRequest, TerminateJobFlowsResponse> {
            serializer = TerminateJobFlowsOperationSerializer()
            deserializer = TerminateJobFlowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TerminateJobFlows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.
     */
    override suspend fun updateStudio(input: UpdateStudioRequest): UpdateStudioResponse {
        val op = SdkHttpOperation.build<UpdateStudioRequest, UpdateStudioResponse> {
            serializer = UpdateStudioOperationSerializer()
            deserializer = UpdateStudioOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStudio"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the session policy attached to the user or group for the specified Amazon EMR Studio.
     */
    override suspend fun updateStudioSessionMapping(input: UpdateStudioSessionMappingRequest): UpdateStudioSessionMappingResponse {
        val op = SdkHttpOperation.build<UpdateStudioSessionMappingRequest, UpdateStudioSessionMappingResponse> {
            serializer = UpdateStudioSessionMappingOperationSerializer()
            deserializer = UpdateStudioSessionMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStudioSessionMapping"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("ElasticMapReduce", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticmapreduce"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "elasticmapreduce")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
