// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * This input identifies an Amazon EMR resource and a list of tags to attach.
 */
class AddTagsRequest private constructor(builder: Builder) {
    /**
     * The Amazon EMR resource identifier to which tags will be added. For example, a cluster identifier or an Amazon EMR Studio ID.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * A list of tags to associate with a resource. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.AddTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddTagsRequest(")
        append("resourceId=$resourceId,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddTagsRequest

        if (resourceId != other.resourceId) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.AddTagsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon EMR resource identifier to which tags will be added. For example, a cluster identifier or an Amazon EMR Studio ID.
         */
        var resourceId: kotlin.String? = null
        /**
         * A list of tags to associate with a resource. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.
         */
        var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.AddTagsRequest) : this() {
            this.resourceId = x.resourceId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.AddTagsRequest = AddTagsRequest(this)
    }
}
