// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * A configuration for Amazon EMR block public access. When `BlockPublicSecurityGroupRules` is set to `true`, Amazon EMR prevents cluster creation if one of the cluster's security groups has a rule that allows inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using `PermittedPublicSecurityGroupRuleRanges`.
 */
class BlockPublicAccessConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether Amazon EMR block public access is enabled (`true`) or disabled (`false`). By default, the value is `false` for accounts that have created EMR clusters before July 2019. For accounts created after this, the default is `true`.
     */
    val blockPublicSecurityGroupRules: kotlin.Boolean = builder.blockPublicSecurityGroupRules
    /**
     * The classification within a configuration.
     */
    val classification: kotlin.String? = builder.classification
    /**
     * A list of additional configurations to apply within a configuration object.
     */
    val configurations: List<Configuration>? = builder.configurations
    /**
     * Specifies ports and port ranges that are permitted to have security group rules that allow inbound traffic from all public sources. For example, if Port 23 (Telnet) is specified for `PermittedPublicSecurityGroupRuleRanges`, Amazon EMR allows cluster creation if a security group associated with the cluster has a rule that allows inbound traffic on Port 23 from IPv4 0.0.0.0/0 or IPv6 port ::/0 as the source.
     *
     * By default, Port 22, which is used for SSH access to the cluster EC2 instances, is in the list of `PermittedPublicSecurityGroupRuleRanges`.
     */
    val permittedPublicSecurityGroupRuleRanges: List<PortRange>? = builder.permittedPublicSecurityGroupRuleRanges
    /**
     * A set of properties specified within a configuration classification.
     */
    val properties: Map<String, String>? = builder.properties

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlockPublicAccessConfiguration(")
        append("blockPublicSecurityGroupRules=$blockPublicSecurityGroupRules,")
        append("classification=$classification,")
        append("configurations=$configurations,")
        append("permittedPublicSecurityGroupRuleRanges=$permittedPublicSecurityGroupRuleRanges,")
        append("properties=$properties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockPublicSecurityGroupRules.hashCode()
        result = 31 * result + (classification?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (permittedPublicSecurityGroupRuleRanges?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlockPublicAccessConfiguration

        if (blockPublicSecurityGroupRules != other.blockPublicSecurityGroupRules) return false
        if (classification != other.classification) return false
        if (configurations != other.configurations) return false
        if (permittedPublicSecurityGroupRuleRanges != other.permittedPublicSecurityGroupRuleRanges) return false
        if (properties != other.properties) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether Amazon EMR block public access is enabled (`true`) or disabled (`false`). By default, the value is `false` for accounts that have created EMR clusters before July 2019. For accounts created after this, the default is `true`.
         */
        var blockPublicSecurityGroupRules: kotlin.Boolean = false
        /**
         * The classification within a configuration.
         */
        var classification: kotlin.String? = null
        /**
         * A list of additional configurations to apply within a configuration object.
         */
        var configurations: List<Configuration>? = null
        /**
         * Specifies ports and port ranges that are permitted to have security group rules that allow inbound traffic from all public sources. For example, if Port 23 (Telnet) is specified for `PermittedPublicSecurityGroupRuleRanges`, Amazon EMR allows cluster creation if a security group associated with the cluster has a rule that allows inbound traffic on Port 23 from IPv4 0.0.0.0/0 or IPv6 port ::/0 as the source.
         *
         * By default, Port 22, which is used for SSH access to the cluster EC2 instances, is in the list of `PermittedPublicSecurityGroupRuleRanges`.
         */
        var permittedPublicSecurityGroupRuleRanges: List<PortRange>? = null
        /**
         * A set of properties specified within a configuration classification.
         */
        var properties: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration) : this() {
            this.blockPublicSecurityGroupRules = x.blockPublicSecurityGroupRules
            this.classification = x.classification
            this.configurations = x.configurations
            this.permittedPublicSecurityGroupRuleRanges = x.permittedPublicSecurityGroupRuleRanges
            this.properties = x.properties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.BlockPublicAccessConfiguration = BlockPublicAccessConfiguration(this)
    }
}
