// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Amazon EMR releases 4.x or later.
 *
 * An optional configuration specification to be used when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file. For more information, see [Configuring Applications](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html).
 */
class Configuration private constructor(builder: Builder) {
    /**
     * The classification within a configuration.
     */
    val classification: kotlin.String? = builder.classification
    /**
     * A list of additional configurations to apply within a configuration object.
     */
    val configurations: List<Configuration>? = builder.configurations
    /**
     * A set of properties specified within a configuration classification.
     */
    val properties: Map<String, String>? = builder.properties

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.Configuration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Configuration(")
        append("classification=$classification,")
        append("configurations=$configurations,")
        append("properties=$properties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = classification?.hashCode() ?: 0
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Configuration

        if (classification != other.classification) return false
        if (configurations != other.configurations) return false
        if (properties != other.properties) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.Configuration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The classification within a configuration.
         */
        var classification: kotlin.String? = null
        /**
         * A list of additional configurations to apply within a configuration object.
         */
        var configurations: List<Configuration>? = null
        /**
         * A set of properties specified within a configuration classification.
         */
        var properties: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.Configuration) : this() {
            this.classification = x.classification
            this.configurations = x.configurations
            this.properties = x.properties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.Configuration = Configuration(this)
    }
}
