// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Configuration parameters for an instance fleet modification request.
 *
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 */
class InstanceFleetModifyConfig private constructor(builder: Builder) {
    /**
     * A unique identifier for the instance fleet.
     */
    val instanceFleetId: kotlin.String? = builder.instanceFleetId
    /**
     * The target capacity of On-Demand units for the instance fleet. For more information see InstanceFleetConfig$TargetOnDemandCapacity.
     */
    val targetOnDemandCapacity: kotlin.Int? = builder.targetOnDemandCapacity
    /**
     * The target capacity of Spot units for the instance fleet. For more information, see InstanceFleetConfig$TargetSpotCapacity.
     */
    val targetSpotCapacity: kotlin.Int? = builder.targetSpotCapacity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceFleetModifyConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceFleetModifyConfig(")
        append("instanceFleetId=$instanceFleetId,")
        append("targetOnDemandCapacity=$targetOnDemandCapacity,")
        append("targetSpotCapacity=$targetSpotCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceFleetId?.hashCode() ?: 0
        result = 31 * result + (targetOnDemandCapacity ?: 0)
        result = 31 * result + (targetSpotCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceFleetModifyConfig

        if (instanceFleetId != other.instanceFleetId) return false
        if (targetOnDemandCapacity != other.targetOnDemandCapacity) return false
        if (targetSpotCapacity != other.targetSpotCapacity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceFleetModifyConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the instance fleet.
         */
        var instanceFleetId: kotlin.String? = null
        /**
         * The target capacity of On-Demand units for the instance fleet. For more information see InstanceFleetConfig$TargetOnDemandCapacity.
         */
        var targetOnDemandCapacity: kotlin.Int? = null
        /**
         * The target capacity of Spot units for the instance fleet. For more information, see InstanceFleetConfig$TargetSpotCapacity.
         */
        var targetSpotCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceFleetModifyConfig) : this() {
            this.instanceFleetId = x.instanceFleetId
            this.targetOnDemandCapacity = x.targetOnDemandCapacity
            this.targetSpotCapacity = x.targetSpotCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceFleetModifyConfig = InstanceFleetModifyConfig(this)
    }
}
