// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * The status of the instance fleet.
 *
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 */
class InstanceFleetStatus private constructor(builder: Builder) {
    /**
     * A code representing the instance fleet status.
     * + `PROVISIONING`—The instance fleet is provisioning EC2 resources and is not yet ready to run jobs.
     * + `BOOTSTRAPPING`—EC2 instances and other resources have been provisioned and the bootstrap actions specified for the instances are underway.
     * + `RUNNING`—EC2 instances and other resources are running. They are either executing jobs or waiting to execute jobs.
     * + `RESIZING`—A resize operation is underway. EC2 instances are either being added or removed.
     * + `SUSPENDED`—A resize operation could not complete. Existing EC2 instances are running, but instances can't be added or removed.
     * + `TERMINATING`—The instance fleet is terminating EC2 instances.
     * + `TERMINATED`—The instance fleet is no longer active, and all EC2 instances have been terminated.
     */
    val state: aws.sdk.kotlin.services.emr.model.InstanceFleetState? = builder.state
    /**
     * Provides status change reason details for the instance fleet.
     */
    val stateChangeReason: aws.sdk.kotlin.services.emr.model.InstanceFleetStateChangeReason? = builder.stateChangeReason
    /**
     * Provides historical timestamps for the instance fleet, including the time of creation, the time it became ready to run jobs, and the time of termination.
     */
    val timeline: aws.sdk.kotlin.services.emr.model.InstanceFleetTimeline? = builder.timeline

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceFleetStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceFleetStatus(")
        append("state=$state,")
        append("stateChangeReason=$stateChangeReason,")
        append("timeline=$timeline)")
    }

    override fun hashCode(): kotlin.Int {
        var result = state?.hashCode() ?: 0
        result = 31 * result + (stateChangeReason?.hashCode() ?: 0)
        result = 31 * result + (timeline?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceFleetStatus

        if (state != other.state) return false
        if (stateChangeReason != other.stateChangeReason) return false
        if (timeline != other.timeline) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceFleetStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * A code representing the instance fleet status.
         * + `PROVISIONING`—The instance fleet is provisioning EC2 resources and is not yet ready to run jobs.
         * + `BOOTSTRAPPING`—EC2 instances and other resources have been provisioned and the bootstrap actions specified for the instances are underway.
         * + `RUNNING`—EC2 instances and other resources are running. They are either executing jobs or waiting to execute jobs.
         * + `RESIZING`—A resize operation is underway. EC2 instances are either being added or removed.
         * + `SUSPENDED`—A resize operation could not complete. Existing EC2 instances are running, but instances can't be added or removed.
         * + `TERMINATING`—The instance fleet is terminating EC2 instances.
         * + `TERMINATED`—The instance fleet is no longer active, and all EC2 instances have been terminated.
         */
        var state: aws.sdk.kotlin.services.emr.model.InstanceFleetState? = null
        /**
         * Provides status change reason details for the instance fleet.
         */
        var stateChangeReason: aws.sdk.kotlin.services.emr.model.InstanceFleetStateChangeReason? = null
        /**
         * Provides historical timestamps for the instance fleet, including the time of creation, the time it became ready to run jobs, and the time of termination.
         */
        var timeline: aws.sdk.kotlin.services.emr.model.InstanceFleetTimeline? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceFleetStatus) : this() {
            this.state = x.state
            this.stateChangeReason = x.stateChangeReason
            this.timeline = x.timeline
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceFleetStatus = InstanceFleetStatus(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceFleetStateChangeReason] inside the given [block]
         */
        fun stateChangeReason(block: aws.sdk.kotlin.services.emr.model.InstanceFleetStateChangeReason.Builder.() -> kotlin.Unit) {
            this.stateChangeReason = aws.sdk.kotlin.services.emr.model.InstanceFleetStateChangeReason.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.InstanceFleetTimeline] inside the given [block]
         */
        fun timeline(block: aws.sdk.kotlin.services.emr.model.InstanceFleetTimeline.Builder.() -> kotlin.Unit) {
            this.timeline = aws.sdk.kotlin.services.emr.model.InstanceFleetTimeline.invoke(block)
        }
    }
}
