// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * An instance type configuration for each instance type in an instance fleet, which determines the EC2 instances Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities. When you use an allocation strategy, you can include a maximum of 30 instance type configurations for a fleet. For more information about how to use an allocation strategy, see [Configure Instance Fleets](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html). Without an allocation strategy, you may specify a maximum of five instance type configurations for a fleet.
 *
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 */
class InstanceTypeConfig private constructor(builder: Builder) {
    /**
     * The bid price for each EC2 Spot Instance type as defined by `InstanceType`. Expressed in USD. If neither `BidPrice` nor `BidPriceAsPercentageOfOnDemandPrice` is provided, `BidPriceAsPercentageOfOnDemandPrice` defaults to 100%.
     */
    val bidPrice: kotlin.String? = builder.bidPrice
    /**
     * The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined by `InstanceType`. Expressed as a number (for example, 20 specifies 20%). If neither `BidPrice` nor `BidPriceAsPercentageOfOnDemandPrice` is provided, `BidPriceAsPercentageOfOnDemandPrice` defaults to 100%.
     */
    val bidPriceAsPercentageOfOnDemandPrice: kotlin.Double? = builder.bidPriceAsPercentageOfOnDemandPrice
    /**
     * A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
     */
    val configurations: List<Configuration>? = builder.configurations
    /**
     * The custom AMI ID to use for the instance type.
     */
    val customAmiId: kotlin.String? = builder.customAmiId
    /**
     * The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by `InstanceType`.
     */
    val ebsConfiguration: aws.sdk.kotlin.services.emr.model.EbsConfiguration? = builder.ebsConfiguration
    /**
     * An EC2 instance type, such as `m3.xlarge`.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in InstanceFleetConfig. This value is 1 for a master instance fleet, and must be 1 or greater for core and task instance fleets. Defaults to 1 if not specified.
     */
    val weightedCapacity: kotlin.Int? = builder.weightedCapacity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.InstanceTypeConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceTypeConfig(")
        append("bidPrice=$bidPrice,")
        append("bidPriceAsPercentageOfOnDemandPrice=$bidPriceAsPercentageOfOnDemandPrice,")
        append("configurations=$configurations,")
        append("customAmiId=$customAmiId,")
        append("ebsConfiguration=$ebsConfiguration,")
        append("instanceType=$instanceType,")
        append("weightedCapacity=$weightedCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bidPrice?.hashCode() ?: 0
        result = 31 * result + (bidPriceAsPercentageOfOnDemandPrice?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (customAmiId?.hashCode() ?: 0)
        result = 31 * result + (ebsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (weightedCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceTypeConfig

        if (bidPrice != other.bidPrice) return false
        if (bidPriceAsPercentageOfOnDemandPrice != other.bidPriceAsPercentageOfOnDemandPrice) return false
        if (configurations != other.configurations) return false
        if (customAmiId != other.customAmiId) return false
        if (ebsConfiguration != other.ebsConfiguration) return false
        if (instanceType != other.instanceType) return false
        if (weightedCapacity != other.weightedCapacity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.InstanceTypeConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The bid price for each EC2 Spot Instance type as defined by `InstanceType`. Expressed in USD. If neither `BidPrice` nor `BidPriceAsPercentageOfOnDemandPrice` is provided, `BidPriceAsPercentageOfOnDemandPrice` defaults to 100%.
         */
        var bidPrice: kotlin.String? = null
        /**
         * The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined by `InstanceType`. Expressed as a number (for example, 20 specifies 20%). If neither `BidPrice` nor `BidPriceAsPercentageOfOnDemandPrice` is provided, `BidPriceAsPercentageOfOnDemandPrice` defaults to 100%.
         */
        var bidPriceAsPercentageOfOnDemandPrice: kotlin.Double? = null
        /**
         * A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
         */
        var configurations: List<Configuration>? = null
        /**
         * The custom AMI ID to use for the instance type.
         */
        var customAmiId: kotlin.String? = null
        /**
         * The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by `InstanceType`.
         */
        var ebsConfiguration: aws.sdk.kotlin.services.emr.model.EbsConfiguration? = null
        /**
         * An EC2 instance type, such as `m3.xlarge`.
         */
        var instanceType: kotlin.String? = null
        /**
         * The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in InstanceFleetConfig. This value is 1 for a master instance fleet, and must be 1 or greater for core and task instance fleets. Defaults to 1 if not specified.
         */
        var weightedCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.InstanceTypeConfig) : this() {
            this.bidPrice = x.bidPrice
            this.bidPriceAsPercentageOfOnDemandPrice = x.bidPriceAsPercentageOfOnDemandPrice
            this.configurations = x.configurations
            this.customAmiId = x.customAmiId
            this.ebsConfiguration = x.ebsConfiguration
            this.instanceType = x.instanceType
            this.weightedCapacity = x.weightedCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.InstanceTypeConfig = InstanceTypeConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.EbsConfiguration] inside the given [block]
         */
        fun ebsConfiguration(block: aws.sdk.kotlin.services.emr.model.EbsConfiguration.Builder.() -> kotlin.Unit) {
            this.ebsConfiguration = aws.sdk.kotlin.services.emr.model.EbsConfiguration.invoke(block)
        }
    }
}
