// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model

import aws.smithy.kotlin.runtime.time.Instant

class ListNotebookExecutionsRequest private constructor(builder: Builder) {
    /**
     * The unique ID of the editor associated with the notebook execution.
     */
    val editorId: kotlin.String? = builder.editorId
    /**
     * The beginning of time range filter for listing notebook executions. The default is the timestamp of 30 days ago.
     */
    val from: aws.smithy.kotlin.runtime.time.Instant? = builder.from
    /**
     * The pagination token, returned by a previous `ListNotebookExecutions` call, that indicates the start of the list for this `ListNotebookExecutions` call.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The status filter for listing notebook executions.
     * + `START_PENDING` indicates that the cluster has received the execution request but execution has not begun.
     * + `STARTING` indicates that the execution is starting on the cluster.
     * + `RUNNING` indicates that the execution is being processed by the cluster.
     * + `FINISHING` indicates that execution processing is in the final stages.
     * + `FINISHED` indicates that the execution has completed without error.
     * + `FAILING` indicates that the execution is failing and will not finish successfully.
     * + `FAILED` indicates that the execution failed.
     * + `STOP_PENDING` indicates that the cluster has received a `StopNotebookExecution` request and the stop is pending.
     * + `STOPPING` indicates that the cluster is in the process of stopping the execution as a result of a `StopNotebookExecution` request.
     * + `STOPPED` indicates that the execution stopped because of a `StopNotebookExecution` request.
     */
    val status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = builder.status
    /**
     * The end of time range filter for listing notebook executions. The default is the current timestamp.
     */
    val to: aws.smithy.kotlin.runtime.time.Instant? = builder.to

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.ListNotebookExecutionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListNotebookExecutionsRequest(")
        append("editorId=$editorId,")
        append("from=$from,")
        append("marker=$marker,")
        append("status=$status,")
        append("to=$to)")
    }

    override fun hashCode(): kotlin.Int {
        var result = editorId?.hashCode() ?: 0
        result = 31 * result + (from?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (to?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListNotebookExecutionsRequest

        if (editorId != other.editorId) return false
        if (from != other.from) return false
        if (marker != other.marker) return false
        if (status != other.status) return false
        if (to != other.to) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.ListNotebookExecutionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique ID of the editor associated with the notebook execution.
         */
        var editorId: kotlin.String? = null
        /**
         * The beginning of time range filter for listing notebook executions. The default is the timestamp of 30 days ago.
         */
        var from: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The pagination token, returned by a previous `ListNotebookExecutions` call, that indicates the start of the list for this `ListNotebookExecutions` call.
         */
        var marker: kotlin.String? = null
        /**
         * The status filter for listing notebook executions.
         * + `START_PENDING` indicates that the cluster has received the execution request but execution has not begun.
         * + `STARTING` indicates that the execution is starting on the cluster.
         * + `RUNNING` indicates that the execution is being processed by the cluster.
         * + `FINISHING` indicates that execution processing is in the final stages.
         * + `FINISHED` indicates that the execution has completed without error.
         * + `FAILING` indicates that the execution is failing and will not finish successfully.
         * + `FAILED` indicates that the execution failed.
         * + `STOP_PENDING` indicates that the cluster has received a `StopNotebookExecution` request and the stop is pending.
         * + `STOPPING` indicates that the cluster is in the process of stopping the execution as a result of a `StopNotebookExecution` request.
         * + `STOPPED` indicates that the execution stopped because of a `StopNotebookExecution` request.
         */
        var status: aws.sdk.kotlin.services.emr.model.NotebookExecutionStatus? = null
        /**
         * The end of time range filter for listing notebook executions. The default is the current timestamp.
         */
        var to: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.ListNotebookExecutionsRequest) : this() {
            this.editorId = x.editorId
            this.from = x.from
            this.marker = x.marker
            this.status = x.status
            this.to = x.to
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.ListNotebookExecutionsRequest = ListNotebookExecutionsRequest(this)
    }
}
