// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * This input identifies an Amazon EMR resource and a list of tags to remove.
 */
class RemoveTagsRequest private constructor(builder: Builder) {
    /**
     * The Amazon EMR resource identifier from which tags will be removed. For example, a cluster identifier or an Amazon EMR Studio ID.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * A list of tag keys to remove from the resource.
     */
    val tagKeys: List<String>? = builder.tagKeys

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.RemoveTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemoveTagsRequest(")
        append("resourceId=$resourceId,")
        append("tagKeys=$tagKeys)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemoveTagsRequest

        if (resourceId != other.resourceId) return false
        if (tagKeys != other.tagKeys) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.RemoveTagsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon EMR resource identifier from which tags will be removed. For example, a cluster identifier or an Amazon EMR Studio ID.
         */
        var resourceId: kotlin.String? = null
        /**
         * A list of tag keys to remove from the resource.
         */
        var tagKeys: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.RemoveTagsRequest) : this() {
            this.resourceId = x.resourceId
            this.tagKeys = x.tagKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.RemoveTagsRequest = RemoveTagsRequest(this)
    }
}
