// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * The upper and lower EC2 instance limits for an automatic scaling policy. Automatic scaling activities triggered by automatic scaling rules will not cause an instance group to grow above or below these limits.
 */
class ScalingConstraints private constructor(builder: Builder) {
    /**
     * The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow. Scale-out activities will not add instances beyond this boundary.
     */
    val maxCapacity: kotlin.Int? = builder.maxCapacity
    /**
     * The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink. Scale-in activities will not terminate instances below this boundary.
     */
    val minCapacity: kotlin.Int? = builder.minCapacity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.ScalingConstraints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingConstraints(")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxCapacity ?: 0
        result = 31 * result + (minCapacity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingConstraints

        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.ScalingConstraints = Builder(this).apply(block).build()

    class Builder {
        /**
         * The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow. Scale-out activities will not add instances beyond this boundary.
         */
        var maxCapacity: kotlin.Int? = null
        /**
         * The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink. Scale-in activities will not terminate instances below this boundary.
         */
        var minCapacity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.ScalingConstraints) : this() {
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.ScalingConstraints = ScalingConstraints(this)
    }
}
