// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.paginators

import aws.sdk.kotlin.services.emr.EmrClient
import aws.sdk.kotlin.services.emr.model.ClusterSummary
import aws.sdk.kotlin.services.emr.model.Command
import aws.sdk.kotlin.services.emr.model.Instance
import aws.sdk.kotlin.services.emr.model.InstanceFleet
import aws.sdk.kotlin.services.emr.model.InstanceGroup
import aws.sdk.kotlin.services.emr.model.ListBootstrapActionsRequest
import aws.sdk.kotlin.services.emr.model.ListBootstrapActionsResponse
import aws.sdk.kotlin.services.emr.model.ListClustersRequest
import aws.sdk.kotlin.services.emr.model.ListClustersResponse
import aws.sdk.kotlin.services.emr.model.ListInstanceFleetsRequest
import aws.sdk.kotlin.services.emr.model.ListInstanceFleetsResponse
import aws.sdk.kotlin.services.emr.model.ListInstanceGroupsRequest
import aws.sdk.kotlin.services.emr.model.ListInstanceGroupsResponse
import aws.sdk.kotlin.services.emr.model.ListInstancesRequest
import aws.sdk.kotlin.services.emr.model.ListInstancesResponse
import aws.sdk.kotlin.services.emr.model.ListNotebookExecutionsRequest
import aws.sdk.kotlin.services.emr.model.ListNotebookExecutionsResponse
import aws.sdk.kotlin.services.emr.model.ListReleaseLabelsRequest
import aws.sdk.kotlin.services.emr.model.ListReleaseLabelsResponse
import aws.sdk.kotlin.services.emr.model.ListSecurityConfigurationsRequest
import aws.sdk.kotlin.services.emr.model.ListSecurityConfigurationsResponse
import aws.sdk.kotlin.services.emr.model.ListStepsRequest
import aws.sdk.kotlin.services.emr.model.ListStepsResponse
import aws.sdk.kotlin.services.emr.model.ListStudioSessionMappingsRequest
import aws.sdk.kotlin.services.emr.model.ListStudioSessionMappingsResponse
import aws.sdk.kotlin.services.emr.model.ListStudiosRequest
import aws.sdk.kotlin.services.emr.model.ListStudiosResponse
import aws.sdk.kotlin.services.emr.model.NotebookExecutionSummary
import aws.sdk.kotlin.services.emr.model.SecurityConfigurationSummary
import aws.sdk.kotlin.services.emr.model.SessionMappingSummary
import aws.sdk.kotlin.services.emr.model.StepSummary
import aws.sdk.kotlin.services.emr.model.StudioSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListBootstrapActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBootstrapActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBootstrapActionsResponse]
 */
fun EmrClient.listBootstrapActionsPaginated(initialRequest: ListBootstrapActionsRequest): Flow<ListBootstrapActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listBootstrapActionsPaginated.listBootstrapActions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListBootstrapActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBootstrapActionsResponse]
 */
fun EmrClient.listBootstrapActionsPaginated(block: ListBootstrapActionsRequest.Builder.() -> Unit): Flow<ListBootstrapActionsResponse> =
    listBootstrapActionsPaginated(ListBootstrapActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBootstrapActionsPaginated]
 * to access the nested member [Command]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Command]
 */
@JvmName("listBootstrapActionsResponseCommand")
fun Flow<ListBootstrapActionsResponse>.bootstrapActions(): Flow<Command> =
    transform() { response ->
        response.bootstrapActions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
fun EmrClient.listClustersPaginated(initialRequest: ListClustersRequest): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
fun EmrClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersPaginated]
 * to access the nested member [ClusterSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterSummary]
 */
@JvmName("listClustersResponseClusterSummary")
fun Flow<ListClustersResponse>.clusters(): Flow<ClusterSummary> =
    transform() { response ->
        response.clusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstanceFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstanceFleetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceFleetsResponse]
 */
fun EmrClient.listInstanceFleetsPaginated(initialRequest: ListInstanceFleetsRequest): Flow<ListInstanceFleetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listInstanceFleetsPaginated.listInstanceFleets(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListInstanceFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceFleetsResponse]
 */
fun EmrClient.listInstanceFleetsPaginated(block: ListInstanceFleetsRequest.Builder.() -> Unit): Flow<ListInstanceFleetsResponse> =
    listInstanceFleetsPaginated(ListInstanceFleetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstanceFleetsPaginated]
 * to access the nested member [InstanceFleet]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceFleet]
 */
@JvmName("listInstanceFleetsResponseInstanceFleet")
fun Flow<ListInstanceFleetsResponse>.instanceFleets(): Flow<InstanceFleet> =
    transform() { response ->
        response.instanceFleets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstanceGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstanceGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceGroupsResponse]
 */
fun EmrClient.listInstanceGroupsPaginated(initialRequest: ListInstanceGroupsRequest): Flow<ListInstanceGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listInstanceGroupsPaginated.listInstanceGroups(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListInstanceGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstanceGroupsResponse]
 */
fun EmrClient.listInstanceGroupsPaginated(block: ListInstanceGroupsRequest.Builder.() -> Unit): Flow<ListInstanceGroupsResponse> =
    listInstanceGroupsPaginated(ListInstanceGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstanceGroupsPaginated]
 * to access the nested member [InstanceGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceGroup]
 */
@JvmName("listInstanceGroupsResponseInstanceGroup")
fun Flow<ListInstanceGroupsResponse>.instanceGroups(): Flow<InstanceGroup> =
    transform() { response ->
        response.instanceGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstancesResponse]
 */
fun EmrClient.listInstancesPaginated(initialRequest: ListInstancesRequest): Flow<ListInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listInstancesPaginated.listInstances(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstancesResponse]
 */
fun EmrClient.listInstancesPaginated(block: ListInstancesRequest.Builder.() -> Unit): Flow<ListInstancesResponse> =
    listInstancesPaginated(ListInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInstancesPaginated]
 * to access the nested member [Instance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Instance]
 */
@JvmName("listInstancesResponseInstance")
fun Flow<ListInstancesResponse>.instances(): Flow<Instance> =
    transform() { response ->
        response.instances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListNotebookExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNotebookExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotebookExecutionsResponse]
 */
fun EmrClient.listNotebookExecutionsPaginated(initialRequest: ListNotebookExecutionsRequest): Flow<ListNotebookExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listNotebookExecutionsPaginated.listNotebookExecutions(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListNotebookExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotebookExecutionsResponse]
 */
fun EmrClient.listNotebookExecutionsPaginated(block: ListNotebookExecutionsRequest.Builder.() -> Unit): Flow<ListNotebookExecutionsResponse> =
    listNotebookExecutionsPaginated(ListNotebookExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listNotebookExecutionsPaginated]
 * to access the nested member [NotebookExecutionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NotebookExecutionSummary]
 */
@JvmName("listNotebookExecutionsResponseNotebookExecutionSummary")
fun Flow<ListNotebookExecutionsResponse>.notebookExecutions(): Flow<NotebookExecutionSummary> =
    transform() { response ->
        response.notebookExecutions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReleaseLabelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReleaseLabelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReleaseLabelsResponse]
 */
fun EmrClient.listReleaseLabelsPaginated(initialRequest: ListReleaseLabelsRequest): Flow<ListReleaseLabelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReleaseLabelsPaginated.listReleaseLabels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListReleaseLabelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReleaseLabelsResponse]
 */
fun EmrClient.listReleaseLabelsPaginated(block: ListReleaseLabelsRequest.Builder.() -> Unit): Flow<ListReleaseLabelsResponse> =
    listReleaseLabelsPaginated(ListReleaseLabelsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSecurityConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecurityConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityConfigurationsResponse]
 */
fun EmrClient.listSecurityConfigurationsPaginated(initialRequest: ListSecurityConfigurationsRequest): Flow<ListSecurityConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listSecurityConfigurationsPaginated.listSecurityConfigurations(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListSecurityConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityConfigurationsResponse]
 */
fun EmrClient.listSecurityConfigurationsPaginated(block: ListSecurityConfigurationsRequest.Builder.() -> Unit): Flow<ListSecurityConfigurationsResponse> =
    listSecurityConfigurationsPaginated(ListSecurityConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSecurityConfigurationsPaginated]
 * to access the nested member [SecurityConfigurationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SecurityConfigurationSummary]
 */
@JvmName("listSecurityConfigurationsResponseSecurityConfigurationSummary")
fun Flow<ListSecurityConfigurationsResponse>.securityConfigurations(): Flow<SecurityConfigurationSummary> =
    transform() { response ->
        response.securityConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStepsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStepsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStepsResponse]
 */
fun EmrClient.listStepsPaginated(initialRequest: ListStepsRequest): Flow<ListStepsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listStepsPaginated.listSteps(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListStepsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStepsResponse]
 */
fun EmrClient.listStepsPaginated(block: ListStepsRequest.Builder.() -> Unit): Flow<ListStepsResponse> =
    listStepsPaginated(ListStepsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStepsPaginated]
 * to access the nested member [StepSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StepSummary]
 */
@JvmName("listStepsResponseStepSummary")
fun Flow<ListStepsResponse>.steps(): Flow<StepSummary> =
    transform() { response ->
        response.steps?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStudiosResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStudiosRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStudiosResponse]
 */
fun EmrClient.listStudiosPaginated(initialRequest: ListStudiosRequest): Flow<ListStudiosResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listStudiosPaginated.listStudios(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListStudiosResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStudiosResponse]
 */
fun EmrClient.listStudiosPaginated(block: ListStudiosRequest.Builder.() -> Unit): Flow<ListStudiosResponse> =
    listStudiosPaginated(ListStudiosRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStudiosPaginated]
 * to access the nested member [StudioSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StudioSummary]
 */
@JvmName("listStudiosResponseStudioSummary")
fun Flow<ListStudiosResponse>.studios(): Flow<StudioSummary> =
    transform() { response ->
        response.studios?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStudioSessionMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStudioSessionMappingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStudioSessionMappingsResponse]
 */
fun EmrClient.listStudioSessionMappingsPaginated(initialRequest: ListStudioSessionMappingsRequest): Flow<ListStudioSessionMappingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listStudioSessionMappingsPaginated.listStudioSessionMappings(req)
            isFirstPage = false
            cursor = result.marker
            emit(result)
        }
    }

/**
 * Paginate over [ListStudioSessionMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStudioSessionMappingsResponse]
 */
fun EmrClient.listStudioSessionMappingsPaginated(block: ListStudioSessionMappingsRequest.Builder.() -> Unit): Flow<ListStudioSessionMappingsResponse> =
    listStudioSessionMappingsPaginated(ListStudioSessionMappingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStudioSessionMappingsPaginated]
 * to access the nested member [SessionMappingSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SessionMappingSummary]
 */
@JvmName("listStudioSessionMappingsResponseSessionMappingSummary")
fun Flow<ListStudioSessionMappingsResponse>.sessionMappings(): Flow<SessionMappingSummary> =
    transform() { response ->
        response.sessionMappings?.forEach {
            emit(it)
        }
    }
