// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.emr.model.EmrException
import aws.sdk.kotlin.services.emr.model.InstanceFleet
import aws.sdk.kotlin.services.emr.model.ListInstanceFleetsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListInstanceFleetsOperationDeserializer: HttpDeserialize<ListInstanceFleetsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListInstanceFleetsResponse {
        if (!response.status.isSuccess()) {
            throwListInstanceFleetsError(context, response)
        }
        val builder = ListInstanceFleetsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListInstanceFleetsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListInstanceFleetsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EmrException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EmrException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListInstanceFleetsOperationBody(builder: ListInstanceFleetsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCEFLEETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InstanceFleets"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCEFLEETS_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCEFLEETS_DESCRIPTOR.index -> builder.instanceFleets =
                    deserializer.deserializeList(INSTANCEFLEETS_DESCRIPTOR) {
                        val col0 = mutableListOf<InstanceFleet>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstanceFleetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
