// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.transform

import aws.sdk.kotlin.services.emr.model.ExecutionEngineConfig
import aws.sdk.kotlin.services.emr.model.StartNotebookExecutionRequest
import aws.sdk.kotlin.services.emr.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartNotebookExecutionOperationSerializer: HttpSerialize<StartNotebookExecutionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartNotebookExecutionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeStartNotebookExecutionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeStartNotebookExecutionOperationBody(context: ExecutionContext, input: StartNotebookExecutionRequest): ByteArray {
    val serializer = JsonSerializer()
    val EDITORID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EditorId"))
    val EXECUTIONENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExecutionEngine"))
    val NOTEBOOKEXECUTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookExecutionName"))
    val NOTEBOOKINSTANCESECURITYGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookInstanceSecurityGroupId"))
    val NOTEBOOKPARAMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookParams"))
    val RELATIVEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RelativePath"))
    val SERVICEROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceRole"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EDITORID_DESCRIPTOR)
        field(EXECUTIONENGINE_DESCRIPTOR)
        field(NOTEBOOKEXECUTIONNAME_DESCRIPTOR)
        field(NOTEBOOKINSTANCESECURITYGROUPID_DESCRIPTOR)
        field(NOTEBOOKPARAMS_DESCRIPTOR)
        field(RELATIVEPATH_DESCRIPTOR)
        field(SERVICEROLE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.editorId?.let { field(EDITORID_DESCRIPTOR, it) }
        input.executionEngine?.let { field(EXECUTIONENGINE_DESCRIPTOR, it, ::serializeExecutionEngineConfigDocument) }
        input.notebookExecutionName?.let { field(NOTEBOOKEXECUTIONNAME_DESCRIPTOR, it) }
        input.notebookInstanceSecurityGroupId?.let { field(NOTEBOOKINSTANCESECURITYGROUPID_DESCRIPTOR, it) }
        input.notebookParams?.let { field(NOTEBOOKPARAMS_DESCRIPTOR, it) }
        input.relativePath?.let { field(RELATIVEPATH_DESCRIPTOR, it) }
        input.serviceRole?.let { field(SERVICEROLE_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
