// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.eventbridge.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.eventbridge.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Amazon EventBridge helps you to respond to state changes in your Amazon Web Services resources. When your
 * resources change state, they automatically send events to an event stream. You can create
 * rules that match selected events in the stream and route them to targets to take action. You
 * can also use rules to take action on a predetermined schedule. For example, you can configure
 * rules to:
 * Automatically invoke an Lambda function to update DNS entries when an event
 * notifies you that Amazon EC2 instance enters the running state.
 * Direct specific API records from CloudTrail to an Amazon Kinesis data stream for
 * detailed analysis of potential security or availability risks.
 * Periodically invoke a built-in target to create a snapshot of an Amazon EBS
 * volume.
 * For more information about the features of Amazon EventBridge, see the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide">Amazon EventBridge User
 * Guide.
 */
interface EventBridgeClient : SdkClient {

    override val serviceName: String
        get() = "EventBridge"
    /**
     * EventBridgeClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): EventBridgeClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultEventBridgeClient(config)
        }

        operator fun invoke(config: Config): EventBridgeClient = DefaultEventBridgeClient(config)

        /**
         * Construct a [EventBridgeClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): EventBridgeClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return EventBridgeClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Activates a partner event source that has been deactivated. Once activated, your matching
     * event bus will start receiving events from the event source.
     */
    suspend fun activateEventSource(input: ActivateEventSourceRequest): ActivateEventSourceResponse

    /**
     * Activates a partner event source that has been deactivated. Once activated, your matching
     * event bus will start receiving events from the event source.
     */
    suspend fun activateEventSource(block: ActivateEventSourceRequest.Builder.() -> Unit) = activateEventSource(ActivateEventSourceRequest.Builder().apply(block).build())

    /**
     * Cancels the specified replay.
     */
    suspend fun cancelReplay(input: CancelReplayRequest): CancelReplayResponse

    /**
     * Cancels the specified replay.
     */
    suspend fun cancelReplay(block: CancelReplayRequest.Builder.() -> Unit) = cancelReplay(CancelReplayRequest.Builder().apply(block).build())

    /**
     * Creates an API destination, which is an HTTP invocation endpoint configured as a target
     * for events.
     */
    suspend fun createApiDestination(input: CreateApiDestinationRequest): CreateApiDestinationResponse

    /**
     * Creates an API destination, which is an HTTP invocation endpoint configured as a target
     * for events.
     */
    suspend fun createApiDestination(block: CreateApiDestinationRequest.Builder.() -> Unit) = createApiDestination(CreateApiDestinationRequest.Builder().apply(block).build())

    /**
     * Creates an archive of events with the specified settings. When you create an archive,
     * incoming events might not immediately start being sent to the archive. Allow a short period of
     * time for changes to take effect. If you do not specify a pattern to filter events sent to the
     * archive, all events are sent to the archive except replayed events. Replayed events are not
     * sent to an archive.
     */
    suspend fun createArchive(input: CreateArchiveRequest): CreateArchiveResponse

    /**
     * Creates an archive of events with the specified settings. When you create an archive,
     * incoming events might not immediately start being sent to the archive. Allow a short period of
     * time for changes to take effect. If you do not specify a pattern to filter events sent to the
     * archive, all events are sent to the archive except replayed events. Replayed events are not
     * sent to an archive.
     */
    suspend fun createArchive(block: CreateArchiveRequest.Builder.() -> Unit) = createArchive(CreateArchiveRequest.Builder().apply(block).build())

    /**
     * Creates a connection. A connection defines the authorization type and credentials to use
     * for authorization with an API destination HTTP endpoint.
     */
    suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse

    /**
     * Creates a connection. A connection defines the authorization type and credentials to use
     * for authorization with an API destination HTTP endpoint.
     */
    suspend fun createConnection(block: CreateConnectionRequest.Builder.() -> Unit) = createConnection(CreateConnectionRequest.Builder().apply(block).build())

    /**
     * Creates a new event bus within your account. This can be a custom event bus which you can
     * use to receive events from your custom applications and services, or it can be a partner event
     * bus which can be matched to a partner event source.
     */
    suspend fun createEventBus(input: CreateEventBusRequest): CreateEventBusResponse

    /**
     * Creates a new event bus within your account. This can be a custom event bus which you can
     * use to receive events from your custom applications and services, or it can be a partner event
     * bus which can be matched to a partner event source.
     */
    suspend fun createEventBus(block: CreateEventBusRequest.Builder.() -> Unit) = createEventBus(CreateEventBusRequest.Builder().apply(block).build())

    /**
     * Called by an SaaS partner to create a partner event source. This operation is not used by
     * Amazon Web Services customers.
     * Each partner event source can be used by one Amazon Web Services account to create a matching partner
     * event bus in that Amazon Web Services account. A SaaS partner must create one partner event source for each
     * Amazon Web Services account that wants to receive those event types.
     * A partner event source creates events based on resources within the SaaS partner's service
     * or application.
     * An Amazon Web Services account that creates a partner event bus that matches the partner event source can
     * use that event bus to receive events from the partner, and then process them using Amazon Web Services Events
     * rules and targets.
     * Partner event source names follow this format:
     * partner_name/event_namespace/event_name
     * partner_name is determined during partner registration and identifies
     * the partner to Amazon Web Services customers. event_namespace is determined by the
     * partner and is a way for the partner to categorize their events.
     * event_name is determined by the partner, and should uniquely identify
     * an event-generating resource within the partner system. The combination of
     * event_namespace and event_name should help Amazon Web Services
     * customers decide whether to create an event bus to receive these events.
     */
    suspend fun createPartnerEventSource(input: CreatePartnerEventSourceRequest): CreatePartnerEventSourceResponse

    /**
     * Called by an SaaS partner to create a partner event source. This operation is not used by
     * Amazon Web Services customers.
     * Each partner event source can be used by one Amazon Web Services account to create a matching partner
     * event bus in that Amazon Web Services account. A SaaS partner must create one partner event source for each
     * Amazon Web Services account that wants to receive those event types.
     * A partner event source creates events based on resources within the SaaS partner's service
     * or application.
     * An Amazon Web Services account that creates a partner event bus that matches the partner event source can
     * use that event bus to receive events from the partner, and then process them using Amazon Web Services Events
     * rules and targets.
     * Partner event source names follow this format:
     * partner_name/event_namespace/event_name
     * partner_name is determined during partner registration and identifies
     * the partner to Amazon Web Services customers. event_namespace is determined by the
     * partner and is a way for the partner to categorize their events.
     * event_name is determined by the partner, and should uniquely identify
     * an event-generating resource within the partner system. The combination of
     * event_namespace and event_name should help Amazon Web Services
     * customers decide whether to create an event bus to receive these events.
     */
    suspend fun createPartnerEventSource(block: CreatePartnerEventSourceRequest.Builder.() -> Unit) = createPartnerEventSource(CreatePartnerEventSourceRequest.Builder().apply(block).build())

    /**
     * You can use this operation to temporarily stop receiving events from the specified partner
     * event source. The matching event bus is not deleted.
     * When you deactivate a partner event source, the source goes into PENDING state. If it
     * remains in PENDING state for more than two weeks, it is deleted.
     * To activate a deactivated partner event source, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html">ActivateEventSource.
     */
    suspend fun deactivateEventSource(input: DeactivateEventSourceRequest): DeactivateEventSourceResponse

    /**
     * You can use this operation to temporarily stop receiving events from the specified partner
     * event source. The matching event bus is not deleted.
     * When you deactivate a partner event source, the source goes into PENDING state. If it
     * remains in PENDING state for more than two weeks, it is deleted.
     * To activate a deactivated partner event source, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html">ActivateEventSource.
     */
    suspend fun deactivateEventSource(block: DeactivateEventSourceRequest.Builder.() -> Unit) = deactivateEventSource(DeactivateEventSourceRequest.Builder().apply(block).build())

    /**
     * Removes all authorization parameters from the connection. This lets you remove the secret
     * from the connection so you can reuse it without having to create a new connection.
     */
    suspend fun deauthorizeConnection(input: DeauthorizeConnectionRequest): DeauthorizeConnectionResponse

    /**
     * Removes all authorization parameters from the connection. This lets you remove the secret
     * from the connection so you can reuse it without having to create a new connection.
     */
    suspend fun deauthorizeConnection(block: DeauthorizeConnectionRequest.Builder.() -> Unit) = deauthorizeConnection(DeauthorizeConnectionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified API destination.
     */
    suspend fun deleteApiDestination(input: DeleteApiDestinationRequest): DeleteApiDestinationResponse

    /**
     * Deletes the specified API destination.
     */
    suspend fun deleteApiDestination(block: DeleteApiDestinationRequest.Builder.() -> Unit) = deleteApiDestination(DeleteApiDestinationRequest.Builder().apply(block).build())

    /**
     * Deletes the specified archive.
     */
    suspend fun deleteArchive(input: DeleteArchiveRequest): DeleteArchiveResponse

    /**
     * Deletes the specified archive.
     */
    suspend fun deleteArchive(block: DeleteArchiveRequest.Builder.() -> Unit) = deleteArchive(DeleteArchiveRequest.Builder().apply(block).build())

    /**
     * Deletes a connection.
     */
    suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * Deletes a connection.
     */
    suspend fun deleteConnection(block: DeleteConnectionRequest.Builder.() -> Unit) = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified custom event bus or partner event bus. All rules associated with
     * this event bus need to be deleted. You can't delete your account's default event bus.
     */
    suspend fun deleteEventBus(input: DeleteEventBusRequest): DeleteEventBusResponse

    /**
     * Deletes the specified custom event bus or partner event bus. All rules associated with
     * this event bus need to be deleted. You can't delete your account's default event bus.
     */
    suspend fun deleteEventBus(block: DeleteEventBusRequest.Builder.() -> Unit) = deleteEventBus(DeleteEventBusRequest.Builder().apply(block).build())

    /**
     * This operation is used by SaaS partners to delete a partner event source. This operation
     * is not used by Amazon Web Services customers.
     * When you delete an event source, the status of the corresponding partner event bus in the
     * Amazon Web Services customer account becomes DELETED.
     */
    suspend fun deletePartnerEventSource(input: DeletePartnerEventSourceRequest): DeletePartnerEventSourceResponse

    /**
     * This operation is used by SaaS partners to delete a partner event source. This operation
     * is not used by Amazon Web Services customers.
     * When you delete an event source, the status of the corresponding partner event bus in the
     * Amazon Web Services customer account becomes DELETED.
     */
    suspend fun deletePartnerEventSource(block: DeletePartnerEventSourceRequest.Builder.() -> Unit) = deletePartnerEventSource(DeletePartnerEventSourceRequest.Builder().apply(block).build())

    /**
     * Deletes the specified rule.
     * Before you can delete the rule, you must remove all targets, using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html">RemoveTargets.
     * When you delete a rule, incoming events might continue to match to the deleted rule. Allow
     * a short period of time for changes to take effect.
     * If you call delete rule multiple times for the same rule, all calls will succeed. When you
     * call delete rule for a non-existent custom eventbus, ResourceNotFoundException is
     * returned.
     * Managed rules are rules created and managed by another Amazon Web Services service on your behalf. These
     * rules are created by those other Amazon Web Services services to support functionality in those services. You
     * can delete these rules using the Force option, but you should do so only if you
     * are sure the other service is not still using that rule.
     */
    suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse

    /**
     * Deletes the specified rule.
     * Before you can delete the rule, you must remove all targets, using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html">RemoveTargets.
     * When you delete a rule, incoming events might continue to match to the deleted rule. Allow
     * a short period of time for changes to take effect.
     * If you call delete rule multiple times for the same rule, all calls will succeed. When you
     * call delete rule for a non-existent custom eventbus, ResourceNotFoundException is
     * returned.
     * Managed rules are rules created and managed by another Amazon Web Services service on your behalf. These
     * rules are created by those other Amazon Web Services services to support functionality in those services. You
     * can delete these rules using the Force option, but you should do so only if you
     * are sure the other service is not still using that rule.
     */
    suspend fun deleteRule(block: DeleteRuleRequest.Builder.() -> Unit) = deleteRule(DeleteRuleRequest.Builder().apply(block).build())

    /**
     * Retrieves details about an API destination.
     */
    suspend fun describeApiDestination(input: DescribeApiDestinationRequest): DescribeApiDestinationResponse

    /**
     * Retrieves details about an API destination.
     */
    suspend fun describeApiDestination(block: DescribeApiDestinationRequest.Builder.() -> Unit) = describeApiDestination(DescribeApiDestinationRequest.Builder().apply(block).build())

    /**
     * Retrieves details about an archive.
     */
    suspend fun describeArchive(input: DescribeArchiveRequest): DescribeArchiveResponse

    /**
     * Retrieves details about an archive.
     */
    suspend fun describeArchive(block: DescribeArchiveRequest.Builder.() -> Unit) = describeArchive(DescribeArchiveRequest.Builder().apply(block).build())

    /**
     * Retrieves details about a connection.
     */
    suspend fun describeConnection(input: DescribeConnectionRequest): DescribeConnectionResponse

    /**
     * Retrieves details about a connection.
     */
    suspend fun describeConnection(block: DescribeConnectionRequest.Builder.() -> Unit) = describeConnection(DescribeConnectionRequest.Builder().apply(block).build())

    /**
     * Displays details about an event bus in your account. This can include the external Amazon Web Services
     * accounts that are permitted to write events to your default event bus, and the associated
     * policy. For custom event buses and partner event buses, it displays the name, ARN, policy,
     * state, and creation time.
     * To enable your account to receive events from other accounts on its default event bus,
     * use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission.
     * For more information about partner event buses, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus.
     */
    suspend fun describeEventBus(input: DescribeEventBusRequest): DescribeEventBusResponse

    /**
     * Displays details about an event bus in your account. This can include the external Amazon Web Services
     * accounts that are permitted to write events to your default event bus, and the associated
     * policy. For custom event buses and partner event buses, it displays the name, ARN, policy,
     * state, and creation time.
     * To enable your account to receive events from other accounts on its default event bus,
     * use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission.
     * For more information about partner event buses, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus.
     */
    suspend fun describeEventBus(block: DescribeEventBusRequest.Builder.() -> Unit) = describeEventBus(DescribeEventBusRequest.Builder().apply(block).build())

    /**
     * This operation lists details about a partner event source that is shared with your
     * account.
     */
    suspend fun describeEventSource(input: DescribeEventSourceRequest): DescribeEventSourceResponse

    /**
     * This operation lists details about a partner event source that is shared with your
     * account.
     */
    suspend fun describeEventSource(block: DescribeEventSourceRequest.Builder.() -> Unit) = describeEventSource(DescribeEventSourceRequest.Builder().apply(block).build())

    /**
     * An SaaS partner can use this operation to list details about a partner event source that
     * they have created. Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html">DescribeEventSource
     * to see details about a partner event source that is
     * shared with them.
     */
    suspend fun describePartnerEventSource(input: DescribePartnerEventSourceRequest): DescribePartnerEventSourceResponse

    /**
     * An SaaS partner can use this operation to list details about a partner event source that
     * they have created. Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html">DescribeEventSource
     * to see details about a partner event source that is
     * shared with them.
     */
    suspend fun describePartnerEventSource(block: DescribePartnerEventSourceRequest.Builder.() -> Unit) = describePartnerEventSource(DescribePartnerEventSourceRequest.Builder().apply(block).build())

    /**
     * Retrieves details about a replay. Use DescribeReplay to determine the
     * progress of a running replay. A replay processes events to replay based on the time in the
     * event, and replays them using 1 minute intervals. If you use StartReplay and
     * specify an EventStartTime and an EventEndTime that covers a 20
     * minute time range, the events are replayed from the first minute of that 20 minute range
     * first. Then the events from the second minute are replayed. You can use
     * DescribeReplay to determine the progress of a replay. The value returned for
     * EventLastReplayedTime indicates the time within the specified time range
     * associated with the last event replayed.
     */
    suspend fun describeReplay(input: DescribeReplayRequest): DescribeReplayResponse

    /**
     * Retrieves details about a replay. Use DescribeReplay to determine the
     * progress of a running replay. A replay processes events to replay based on the time in the
     * event, and replays them using 1 minute intervals. If you use StartReplay and
     * specify an EventStartTime and an EventEndTime that covers a 20
     * minute time range, the events are replayed from the first minute of that 20 minute range
     * first. Then the events from the second minute are replayed. You can use
     * DescribeReplay to determine the progress of a replay. The value returned for
     * EventLastReplayedTime indicates the time within the specified time range
     * associated with the last event replayed.
     */
    suspend fun describeReplay(block: DescribeReplayRequest.Builder.() -> Unit) = describeReplay(DescribeReplayRequest.Builder().apply(block).build())

    /**
     * Describes the specified rule.
     * DescribeRule does not list the targets of a rule. To see the targets associated with a
     * rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule.
     */
    suspend fun describeRule(input: DescribeRuleRequest): DescribeRuleResponse

    /**
     * Describes the specified rule.
     * DescribeRule does not list the targets of a rule. To see the targets associated with a
     * rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule.
     */
    suspend fun describeRule(block: DescribeRuleRequest.Builder.() -> Unit) = describeRule(DescribeRuleRequest.Builder().apply(block).build())

    /**
     * Disables the specified rule. A disabled rule won't match any events, and won't
     * self-trigger if it has a schedule expression.
     * When you disable a rule, incoming events might continue to match to the disabled rule.
     * Allow a short period of time for changes to take effect.
     */
    suspend fun disableRule(input: DisableRuleRequest): DisableRuleResponse

    /**
     * Disables the specified rule. A disabled rule won't match any events, and won't
     * self-trigger if it has a schedule expression.
     * When you disable a rule, incoming events might continue to match to the disabled rule.
     * Allow a short period of time for changes to take effect.
     */
    suspend fun disableRule(block: DisableRuleRequest.Builder.() -> Unit) = disableRule(DisableRuleRequest.Builder().apply(block).build())

    /**
     * Enables the specified rule. If the rule does not exist, the operation fails.
     * When you enable a rule, incoming events might not immediately start matching to a newly
     * enabled rule. Allow a short period of time for changes to take effect.
     */
    suspend fun enableRule(input: EnableRuleRequest): EnableRuleResponse

    /**
     * Enables the specified rule. If the rule does not exist, the operation fails.
     * When you enable a rule, incoming events might not immediately start matching to a newly
     * enabled rule. Allow a short period of time for changes to take effect.
     */
    suspend fun enableRule(block: EnableRuleRequest.Builder.() -> Unit) = enableRule(EnableRuleRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of API destination in the account in the current Region.
     */
    suspend fun listApiDestinations(input: ListApiDestinationsRequest): ListApiDestinationsResponse

    /**
     * Retrieves a list of API destination in the account in the current Region.
     */
    suspend fun listApiDestinations(block: ListApiDestinationsRequest.Builder.() -> Unit) = listApiDestinations(ListApiDestinationsRequest.Builder().apply(block).build())

    /**
     * Lists your archives. You can either list all the archives or you can provide a prefix to
     * match to the archive names. Filter parameters are exclusive.
     */
    suspend fun listArchives(input: ListArchivesRequest): ListArchivesResponse

    /**
     * Lists your archives. You can either list all the archives or you can provide a prefix to
     * match to the archive names. Filter parameters are exclusive.
     */
    suspend fun listArchives(block: ListArchivesRequest.Builder.() -> Unit) = listArchives(ListArchivesRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of connections from the account.
     */
    suspend fun listConnections(input: ListConnectionsRequest): ListConnectionsResponse

    /**
     * Retrieves a list of connections from the account.
     */
    suspend fun listConnections(block: ListConnectionsRequest.Builder.() -> Unit) = listConnections(ListConnectionsRequest.Builder().apply(block).build())

    /**
     * Lists all the event buses in your account, including the default event bus, custom event
     * buses, and partner event buses.
     */
    suspend fun listEventBuses(input: ListEventBusesRequest): ListEventBusesResponse

    /**
     * Lists all the event buses in your account, including the default event bus, custom event
     * buses, and partner event buses.
     */
    suspend fun listEventBuses(block: ListEventBusesRequest.Builder.() -> Unit) = listEventBuses(ListEventBusesRequest.Builder().apply(block).build())

    /**
     * You can use this to see all the partner event sources that have been shared with your Amazon Web Services
     * account. For more information about partner event sources, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus.
     */
    suspend fun listEventSources(input: ListEventSourcesRequest): ListEventSourcesResponse

    /**
     * You can use this to see all the partner event sources that have been shared with your Amazon Web Services
     * account. For more information about partner event sources, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus.
     */
    suspend fun listEventSources(block: ListEventSourcesRequest.Builder.() -> Unit) = listEventSources(ListEventSourcesRequest.Builder().apply(block).build())

    /**
     * An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular
     * partner event source name is associated with. This operation is not used by Amazon Web Services
     * customers.
     */
    suspend fun listPartnerEventSourceAccounts(input: ListPartnerEventSourceAccountsRequest): ListPartnerEventSourceAccountsResponse

    /**
     * An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular
     * partner event source name is associated with. This operation is not used by Amazon Web Services
     * customers.
     */
    suspend fun listPartnerEventSourceAccounts(block: ListPartnerEventSourceAccountsRequest.Builder.() -> Unit) = listPartnerEventSourceAccounts(ListPartnerEventSourceAccountsRequest.Builder().apply(block).build())

    /**
     * An SaaS partner can use this operation to list all the partner event source names that
     * they have created. This operation is not used by Amazon Web Services customers.
     */
    suspend fun listPartnerEventSources(input: ListPartnerEventSourcesRequest): ListPartnerEventSourcesResponse

    /**
     * An SaaS partner can use this operation to list all the partner event source names that
     * they have created. This operation is not used by Amazon Web Services customers.
     */
    suspend fun listPartnerEventSources(block: ListPartnerEventSourcesRequest.Builder.() -> Unit) = listPartnerEventSources(ListPartnerEventSourcesRequest.Builder().apply(block).build())

    /**
     * Lists your replays. You can either list all the replays or you can provide a prefix to
     * match to the replay names. Filter parameters are exclusive.
     */
    suspend fun listReplays(input: ListReplaysRequest): ListReplaysResponse

    /**
     * Lists your replays. You can either list all the replays or you can provide a prefix to
     * match to the replay names. Filter parameters are exclusive.
     */
    suspend fun listReplays(block: ListReplaysRequest.Builder.() -> Unit) = listReplays(ListReplaysRequest.Builder().apply(block).build())

    /**
     * Lists the rules for the specified target. You can see which of the rules in Amazon
     * EventBridge can invoke a specific target in your account.
     */
    suspend fun listRuleNamesByTarget(input: ListRuleNamesByTargetRequest): ListRuleNamesByTargetResponse

    /**
     * Lists the rules for the specified target. You can see which of the rules in Amazon
     * EventBridge can invoke a specific target in your account.
     */
    suspend fun listRuleNamesByTarget(block: ListRuleNamesByTargetRequest.Builder.() -> Unit) = listRuleNamesByTarget(ListRuleNamesByTargetRequest.Builder().apply(block).build())

    /**
     * Lists your Amazon EventBridge rules. You can either list all the rules or you can provide
     * a prefix to match to the rule names.
     * ListRules does not list the targets of a rule. To see the targets associated with a rule,
     * use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule.
     */
    suspend fun listRules(input: ListRulesRequest): ListRulesResponse

    /**
     * Lists your Amazon EventBridge rules. You can either list all the rules or you can provide
     * a prefix to match to the rule names.
     * ListRules does not list the targets of a rule. To see the targets associated with a rule,
     * use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule.
     */
    suspend fun listRules(block: ListRulesRequest.Builder.() -> Unit) = listRules(ListRulesRequest.Builder().apply(block).build())

    /**
     * Displays the tags associated with an EventBridge resource. In EventBridge, rules and event
     * buses can be tagged.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Displays the tags associated with an EventBridge resource. In EventBridge, rules and event
     * buses can be tagged.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists the targets assigned to the specified rule.
     */
    suspend fun listTargetsByRule(input: ListTargetsByRuleRequest): ListTargetsByRuleResponse

    /**
     * Lists the targets assigned to the specified rule.
     */
    suspend fun listTargetsByRule(block: ListTargetsByRuleRequest.Builder.() -> Unit) = listTargetsByRule(ListTargetsByRuleRequest.Builder().apply(block).build())

    /**
     * Sends custom events to Amazon EventBridge so that they can be matched to rules.
     */
    suspend fun putEvents(input: PutEventsRequest): PutEventsResponse

    /**
     * Sends custom events to Amazon EventBridge so that they can be matched to rules.
     */
    suspend fun putEvents(block: PutEventsRequest.Builder.() -> Unit) = putEvents(PutEventsRequest.Builder().apply(block).build())

    /**
     * This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services
     * customers do not use this operation.
     */
    suspend fun putPartnerEvents(input: PutPartnerEventsRequest): PutPartnerEventsResponse

    /**
     * This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services
     * customers do not use this operation.
     */
    suspend fun putPartnerEvents(block: PutPartnerEventsRequest.Builder.() -> Unit) = putPartnerEvents(PutPartnerEventsRequest.Builder().apply(block).build())

    /**
     * Running PutPermission permits the specified Amazon Web Services account or Amazon Web Services organization
     * to put events to the specified event bus. Amazon EventBridge (CloudWatch
     * Events) rules in your account are triggered by these events arriving to an event bus in your
     * account.
     * For another account to send events to your account, that external account must have an
     * EventBridge rule with your account's event bus as a target.
     * To enable multiple Amazon Web Services accounts to put events to your event bus, run
     * PutPermission once for each of these accounts. Or, if all the accounts are
     * members of the same Amazon Web Services organization, you can run PutPermission once specifying
     * Principal as "*" and specifying the Amazon Web Services organization ID in
     * Condition, to grant permissions to all accounts in that organization.
     * If you grant permissions using an organization, then accounts in that organization must
     * specify a RoleArn with proper permissions when they use PutTarget to
     * add your account's event bus as a target. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and
     * Receiving Events Between Amazon Web Services Accounts in the Amazon EventBridge User
     * Guide.
     * The permission policy on the event bus cannot exceed 10 KB in size.
     */
    suspend fun putPermission(input: PutPermissionRequest): PutPermissionResponse

    /**
     * Running PutPermission permits the specified Amazon Web Services account or Amazon Web Services organization
     * to put events to the specified event bus. Amazon EventBridge (CloudWatch
     * Events) rules in your account are triggered by these events arriving to an event bus in your
     * account.
     * For another account to send events to your account, that external account must have an
     * EventBridge rule with your account's event bus as a target.
     * To enable multiple Amazon Web Services accounts to put events to your event bus, run
     * PutPermission once for each of these accounts. Or, if all the accounts are
     * members of the same Amazon Web Services organization, you can run PutPermission once specifying
     * Principal as "*" and specifying the Amazon Web Services organization ID in
     * Condition, to grant permissions to all accounts in that organization.
     * If you grant permissions using an organization, then accounts in that organization must
     * specify a RoleArn with proper permissions when they use PutTarget to
     * add your account's event bus as a target. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and
     * Receiving Events Between Amazon Web Services Accounts in the Amazon EventBridge User
     * Guide.
     * The permission policy on the event bus cannot exceed 10 KB in size.
     */
    suspend fun putPermission(block: PutPermissionRequest.Builder.() -> Unit) = putPermission(PutPermissionRequest.Builder().apply(block).build())

    /**
     * Creates or updates the specified rule. Rules are enabled by default, or based on value of
     * the state. You can disable a rule using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html">DisableRule.
     * A single rule watches for events from a single event bus. Events generated by Amazon Web Services services
     * go to your account's default event bus. Events generated by SaaS partner services or
     * applications go to the matching partner event bus. If you have custom applications or
     * services, you can specify whether their events go to your default event bus or a custom event
     * bus that you have created. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus.
     * If you are updating an existing rule, the rule is replaced with what you specify in this
     * PutRule command. If you omit arguments in PutRule, the old values
     * for those arguments are not kept. Instead, they are replaced with null values.
     * When you create or update a rule, incoming events might not immediately start matching to
     * new or updated rules. Allow a short period of time for changes to take effect.
     * A rule must contain at least an EventPattern or ScheduleExpression. Rules with
     * EventPatterns are triggered when a matching event is observed. Rules with ScheduleExpressions
     * self-trigger based on the given schedule. A rule can have both an EventPattern and a
     * ScheduleExpression, in which case the rule triggers on matching events as well as on a
     * schedule.
     * When you initially create a rule, you can optionally assign one or more tags to the rule.
     * Tags can help you organize and categorize your resources. You can also use them to scope user
     * permissions, by granting a user permission to access or change only rules with certain tag
     * values. To use the PutRule operation and assign tags, you must have both the
     * events:PutRule and events:TagResource permissions.
     * If you are updating an existing rule, any tags you specify in the PutRule
     * operation are ignored. To update the tags of an existing rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html">TagResource and <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html">UntagResource.
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs).
     * However, EventBridge uses an exact match in event patterns and rules. Be sure to use the
     * correct ARN characters when creating event patterns so that they match the ARN syntax in the
     * event you want to match.
     * In EventBridge, it is possible to create rules that lead to infinite loops, where a rule
     * is fired repeatedly. For example, a rule might detect that ACLs have changed on an S3 bucket,
     * and trigger software to change them to the desired state. If the rule is not written
     * carefully, the subsequent change to the ACLs fires the rule again, creating an infinite
     * loop.
     * To prevent this, write the rules so that the triggered actions do not re-fire the same
     * rule. For example, your rule could fire only if ACLs are found to be in a bad state, instead
     * of after any change.
     * An infinite loop can quickly cause higher than expected charges. We recommend that you use
     * budgeting, which alerts you when charges exceed your specified limit. For more information,
     * see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your Costs with
     * Budgets.
     */
    suspend fun putRule(input: PutRuleRequest): PutRuleResponse

    /**
     * Creates or updates the specified rule. Rules are enabled by default, or based on value of
     * the state. You can disable a rule using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html">DisableRule.
     * A single rule watches for events from a single event bus. Events generated by Amazon Web Services services
     * go to your account's default event bus. Events generated by SaaS partner services or
     * applications go to the matching partner event bus. If you have custom applications or
     * services, you can specify whether their events go to your default event bus or a custom event
     * bus that you have created. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus.
     * If you are updating an existing rule, the rule is replaced with what you specify in this
     * PutRule command. If you omit arguments in PutRule, the old values
     * for those arguments are not kept. Instead, they are replaced with null values.
     * When you create or update a rule, incoming events might not immediately start matching to
     * new or updated rules. Allow a short period of time for changes to take effect.
     * A rule must contain at least an EventPattern or ScheduleExpression. Rules with
     * EventPatterns are triggered when a matching event is observed. Rules with ScheduleExpressions
     * self-trigger based on the given schedule. A rule can have both an EventPattern and a
     * ScheduleExpression, in which case the rule triggers on matching events as well as on a
     * schedule.
     * When you initially create a rule, you can optionally assign one or more tags to the rule.
     * Tags can help you organize and categorize your resources. You can also use them to scope user
     * permissions, by granting a user permission to access or change only rules with certain tag
     * values. To use the PutRule operation and assign tags, you must have both the
     * events:PutRule and events:TagResource permissions.
     * If you are updating an existing rule, any tags you specify in the PutRule
     * operation are ignored. To update the tags of an existing rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html">TagResource and <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html">UntagResource.
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs).
     * However, EventBridge uses an exact match in event patterns and rules. Be sure to use the
     * correct ARN characters when creating event patterns so that they match the ARN syntax in the
     * event you want to match.
     * In EventBridge, it is possible to create rules that lead to infinite loops, where a rule
     * is fired repeatedly. For example, a rule might detect that ACLs have changed on an S3 bucket,
     * and trigger software to change them to the desired state. If the rule is not written
     * carefully, the subsequent change to the ACLs fires the rule again, creating an infinite
     * loop.
     * To prevent this, write the rules so that the triggered actions do not re-fire the same
     * rule. For example, your rule could fire only if ACLs are found to be in a bad state, instead
     * of after any change.
     * An infinite loop can quickly cause higher than expected charges. We recommend that you use
     * budgeting, which alerts you when charges exceed your specified limit. For more information,
     * see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your Costs with
     * Budgets.
     */
    suspend fun putRule(block: PutRuleRequest.Builder.() -> Unit) = putRule(PutRuleRequest.Builder().apply(block).build())

    /**
     * Adds the specified targets to the specified rule, or updates the targets if they are
     * already associated with the rule.
     * Targets are the resources that are invoked when a rule is triggered.
     * You can configure the following as targets for Events:
     * <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API
     * destination
     * Amazon API Gateway REST API endpoints
     * API Gateway
     * Batch job queue
     * CloudWatch Logs group
     * CodeBuild project
     * CodePipeline
     * Amazon EC2 CreateSnapshot API call
     * Amazon EC2 RebootInstances API call
     * Amazon EC2 StopInstances API call
     * Amazon EC2 TerminateInstances API call
     * Amazon ECS tasks
     * Event bus in a different Amazon Web Services account or Region.
     * You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon)
     * us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.
     * Firehose delivery stream (Kinesis Data Firehose)
     * Inspector assessment template (Amazon Inspector)
     * Kinesis stream (Kinesis Data Stream)
     * Lambda function
     * Redshift clusters (Data API statement execution)
     * Amazon SNS topic
     * Amazon SQS queues (includes FIFO queues
     * SSM Automation
     * SSM OpsItem
     * SSM Run Command
     * Step Functions state machines
     * Creating rules with built-in targets is supported only in the Amazon Web Services Management Console. The
     * built-in targets are EC2 CreateSnapshot API call, EC2 RebootInstances API
     * call, EC2 StopInstances API call, and EC2 TerminateInstances API
     * call.
     * For some target types, PutTargets provides target-specific parameters. If the
     * target is a Kinesis data stream, you can optionally specify which shard the event goes to by
     * using the KinesisParameters argument. To invoke a command on multiple EC2
     * instances with one rule, you can use the RunCommandParameters field.
     * To be able to make API calls against the resources that you own, Amazon EventBridge
     * needs the appropriate permissions. For Lambda and Amazon SNS
     * resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams,
     * Step Functions state machines and API Gateway REST APIs, EventBridge relies on
     * IAM roles that you specify in the RoleARN argument in PutTargets.
     * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication
     * and Access Control in the Amazon EventBridge User Guide.
     * If another Amazon Web Services account is in the same region and has granted you permission (using
     * PutPermission), you can send events to that account. Set that account's event
     * bus as a target of the rules in your account. To send the matched events to the other account,
     * specify that account's event bus as the Arn value when you run
     * PutTargets. If your account sends events to another account, your account is
     * charged for each sent event. Each event sent to another account is charged as a custom event.
     * The account receiving the event is not charged. For more information, see <a href="http://aws.amazon.com/eventbridge/pricing/">Amazon EventBridge
     * Pricing.
     * Input, InputPath, and InputTransformer are not
     * available with PutTarget if the target is an event bus of a different Amazon Web Services
     * account.
     * If you are setting the event bus of another account as the target, and that account
     * granted permission to your account through an organization instead of directly by the account
     * ID, then you must specify a RoleArn with proper permissions in the
     * Target structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and
     * Receiving Events Between Amazon Web Services Accounts in the Amazon EventBridge User
     * Guide.
     * For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission.
     * Input, InputPath, and
     * InputTransformer are mutually exclusive and optional
     * parameters of a target. When a rule is triggered due to a matched event:
     * If none of the following arguments are specified for a target, then the entire event
     * is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or
     * Amazon ECS task, in which case nothing from the event is passed to the target).
     * If Input is specified in the form of valid JSON, then
     * the matched event is overridden with this constant.
     * If InputPath is specified in the form of JSONPath
     * (for example, $.detail), then only the part of the event specified in the
     * path is passed to the target (for example, only the detail part of the event is
     * passed).
     * If InputTransformer is specified, then one or more
     * specified JSONPaths are extracted from the event and used as values in a template that you
     * specify as the input to the target.
     * When you specify InputPath or InputTransformer, you must use
     * JSON dot notation, not bracket notation.
     * When you add targets to a rule and the associated rule triggers soon after, new or updated
     * targets might not be immediately invoked. Allow a short period of time for changes to take
     * effect.
     * This action can partially fail if too many requests are made at the same time. If that
     * happens, FailedEntryCount is non-zero in the response and each entry in
     * FailedEntries provides the ID of the failed target and the error code.
     */
    suspend fun putTargets(input: PutTargetsRequest): PutTargetsResponse

    /**
     * Adds the specified targets to the specified rule, or updates the targets if they are
     * already associated with the rule.
     * Targets are the resources that are invoked when a rule is triggered.
     * You can configure the following as targets for Events:
     * <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API
     * destination
     * Amazon API Gateway REST API endpoints
     * API Gateway
     * Batch job queue
     * CloudWatch Logs group
     * CodeBuild project
     * CodePipeline
     * Amazon EC2 CreateSnapshot API call
     * Amazon EC2 RebootInstances API call
     * Amazon EC2 StopInstances API call
     * Amazon EC2 TerminateInstances API call
     * Amazon ECS tasks
     * Event bus in a different Amazon Web Services account or Region.
     * You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon)
     * us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.
     * Firehose delivery stream (Kinesis Data Firehose)
     * Inspector assessment template (Amazon Inspector)
     * Kinesis stream (Kinesis Data Stream)
     * Lambda function
     * Redshift clusters (Data API statement execution)
     * Amazon SNS topic
     * Amazon SQS queues (includes FIFO queues
     * SSM Automation
     * SSM OpsItem
     * SSM Run Command
     * Step Functions state machines
     * Creating rules with built-in targets is supported only in the Amazon Web Services Management Console. The
     * built-in targets are EC2 CreateSnapshot API call, EC2 RebootInstances API
     * call, EC2 StopInstances API call, and EC2 TerminateInstances API
     * call.
     * For some target types, PutTargets provides target-specific parameters. If the
     * target is a Kinesis data stream, you can optionally specify which shard the event goes to by
     * using the KinesisParameters argument. To invoke a command on multiple EC2
     * instances with one rule, you can use the RunCommandParameters field.
     * To be able to make API calls against the resources that you own, Amazon EventBridge
     * needs the appropriate permissions. For Lambda and Amazon SNS
     * resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams,
     * Step Functions state machines and API Gateway REST APIs, EventBridge relies on
     * IAM roles that you specify in the RoleARN argument in PutTargets.
     * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication
     * and Access Control in the Amazon EventBridge User Guide.
     * If another Amazon Web Services account is in the same region and has granted you permission (using
     * PutPermission), you can send events to that account. Set that account's event
     * bus as a target of the rules in your account. To send the matched events to the other account,
     * specify that account's event bus as the Arn value when you run
     * PutTargets. If your account sends events to another account, your account is
     * charged for each sent event. Each event sent to another account is charged as a custom event.
     * The account receiving the event is not charged. For more information, see <a href="http://aws.amazon.com/eventbridge/pricing/">Amazon EventBridge
     * Pricing.
     * Input, InputPath, and InputTransformer are not
     * available with PutTarget if the target is an event bus of a different Amazon Web Services
     * account.
     * If you are setting the event bus of another account as the target, and that account
     * granted permission to your account through an organization instead of directly by the account
     * ID, then you must specify a RoleArn with proper permissions in the
     * Target structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and
     * Receiving Events Between Amazon Web Services Accounts in the Amazon EventBridge User
     * Guide.
     * For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission.
     * Input, InputPath, and
     * InputTransformer are mutually exclusive and optional
     * parameters of a target. When a rule is triggered due to a matched event:
     * If none of the following arguments are specified for a target, then the entire event
     * is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or
     * Amazon ECS task, in which case nothing from the event is passed to the target).
     * If Input is specified in the form of valid JSON, then
     * the matched event is overridden with this constant.
     * If InputPath is specified in the form of JSONPath
     * (for example, $.detail), then only the part of the event specified in the
     * path is passed to the target (for example, only the detail part of the event is
     * passed).
     * If InputTransformer is specified, then one or more
     * specified JSONPaths are extracted from the event and used as values in a template that you
     * specify as the input to the target.
     * When you specify InputPath or InputTransformer, you must use
     * JSON dot notation, not bracket notation.
     * When you add targets to a rule and the associated rule triggers soon after, new or updated
     * targets might not be immediately invoked. Allow a short period of time for changes to take
     * effect.
     * This action can partially fail if too many requests are made at the same time. If that
     * happens, FailedEntryCount is non-zero in the response and each entry in
     * FailedEntries provides the ID of the failed target and the error code.
     */
    suspend fun putTargets(block: PutTargetsRequest.Builder.() -> Unit) = putTargets(PutTargetsRequest.Builder().apply(block).build())

    /**
     * Revokes the permission of another Amazon Web Services account to be able to put events to the specified
     * event bus. Specify the account to revoke by the StatementId value that you
     * associated with the account when you granted it permission with PutPermission.
     * You can find the StatementId by using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html">DescribeEventBus.
     */
    suspend fun removePermission(input: RemovePermissionRequest): RemovePermissionResponse

    /**
     * Revokes the permission of another Amazon Web Services account to be able to put events to the specified
     * event bus. Specify the account to revoke by the StatementId value that you
     * associated with the account when you granted it permission with PutPermission.
     * You can find the StatementId by using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html">DescribeEventBus.
     */
    suspend fun removePermission(block: RemovePermissionRequest.Builder.() -> Unit) = removePermission(RemovePermissionRequest.Builder().apply(block).build())

    /**
     * Removes the specified targets from the specified rule. When the rule is triggered, those
     * targets are no longer be invoked.
     * When you remove a target, when the associated rule triggers, removed targets might
     * continue to be invoked. Allow a short period of time for changes to take effect.
     * This action can partially fail if too many requests are made at the same time. If that
     * happens, FailedEntryCount is non-zero in the response and each entry in
     * FailedEntries provides the ID of the failed target and the error code.
     */
    suspend fun removeTargets(input: RemoveTargetsRequest): RemoveTargetsResponse

    /**
     * Removes the specified targets from the specified rule. When the rule is triggered, those
     * targets are no longer be invoked.
     * When you remove a target, when the associated rule triggers, removed targets might
     * continue to be invoked. Allow a short period of time for changes to take effect.
     * This action can partially fail if too many requests are made at the same time. If that
     * happens, FailedEntryCount is non-zero in the response and each entry in
     * FailedEntries provides the ID of the failed target and the error code.
     */
    suspend fun removeTargets(block: RemoveTargetsRequest.Builder.() -> Unit) = removeTargets(RemoveTargetsRequest.Builder().apply(block).build())

    /**
     * Starts the specified replay. Events are not necessarily replayed in the exact same order
     * that they were added to the archive. A replay processes events to replay based on the time in
     * the event, and replays them using 1 minute intervals. If you specify an
     * EventStartTime and an EventEndTime that covers a 20 minute time
     * range, the events are replayed from the first minute of that 20 minute range first. Then the
     * events from the second minute are replayed. You can use DescribeReplay to
     * determine the progress of a replay. The value returned for EventLastReplayedTime
     * indicates the time within the specified time range associated with the last event
     * replayed.
     */
    suspend fun startReplay(input: StartReplayRequest): StartReplayResponse

    /**
     * Starts the specified replay. Events are not necessarily replayed in the exact same order
     * that they were added to the archive. A replay processes events to replay based on the time in
     * the event, and replays them using 1 minute intervals. If you specify an
     * EventStartTime and an EventEndTime that covers a 20 minute time
     * range, the events are replayed from the first minute of that 20 minute range first. Then the
     * events from the second minute are replayed. You can use DescribeReplay to
     * determine the progress of a replay. The value returned for EventLastReplayedTime
     * indicates the time within the specified time range associated with the last event
     * replayed.
     */
    suspend fun startReplay(block: StartReplayRequest.Builder.() -> Unit) = startReplay(StartReplayRequest.Builder().apply(block).build())

    /**
     * Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can
     * help you organize and categorize your resources. You can also use them to scope user
     * permissions by granting a user permission to access or change only resources with certain tag
     * values. In EventBridge, rules and event buses can be tagged.
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * You can use the TagResource action with a resource that already has tags. If
     * you specify a new tag key, this tag is appended to the list of tags associated with the
     * resource. If you specify a tag key that is already associated with the resource, the new tag
     * value that you specify replaces the previous value for that tag.
     * You can associate as many as 50 tags with a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can
     * help you organize and categorize your resources. You can also use them to scope user
     * permissions by granting a user permission to access or change only resources with certain tag
     * values. In EventBridge, rules and event buses can be tagged.
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * You can use the TagResource action with a resource that already has tags. If
     * you specify a new tag key, this tag is appended to the list of tags associated with the
     * resource. If you specify a tag key that is already associated with the resource, the new tag
     * value that you specify replaces the previous value for that tag.
     * You can associate as many as 50 tags with a resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Tests whether the specified event pattern matches the provided event.
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs).
     * However, EventBridge uses an exact match in event patterns and rules. Be sure to use the
     * correct ARN characters when creating event patterns so that they match the ARN syntax in the
     * event you want to match.
     */
    suspend fun testEventPattern(input: TestEventPatternRequest): TestEventPatternResponse

    /**
     * Tests whether the specified event pattern matches the provided event.
     * Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs).
     * However, EventBridge uses an exact match in event patterns and rules. Be sure to use the
     * correct ARN characters when creating event patterns so that they match the ARN syntax in the
     * event you want to match.
     */
    suspend fun testEventPattern(block: TestEventPatternRequest.Builder.() -> Unit) = testEventPattern(TestEventPatternRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge
     * (CloudWatch Events), rules and event buses can be tagged.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge
     * (CloudWatch Events), rules and event buses can be tagged.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates an API destination.
     */
    suspend fun updateApiDestination(input: UpdateApiDestinationRequest): UpdateApiDestinationResponse

    /**
     * Updates an API destination.
     */
    suspend fun updateApiDestination(block: UpdateApiDestinationRequest.Builder.() -> Unit) = updateApiDestination(UpdateApiDestinationRequest.Builder().apply(block).build())

    /**
     * Updates the specified archive.
     */
    suspend fun updateArchive(input: UpdateArchiveRequest): UpdateArchiveResponse

    /**
     * Updates the specified archive.
     */
    suspend fun updateArchive(block: UpdateArchiveRequest.Builder.() -> Unit) = updateArchive(UpdateArchiveRequest.Builder().apply(block).build())

    /**
     * Updates settings for a connection.
     */
    suspend fun updateConnection(input: UpdateConnectionRequest): UpdateConnectionResponse

    /**
     * Updates settings for a connection.
     */
    suspend fun updateConnection(block: UpdateConnectionRequest.Builder.() -> Unit) = updateConnection(UpdateConnectionRequest.Builder().apply(block).build())
}
