// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about an API destination.
 */
class ApiDestination private constructor(builder: Builder) {
    /**
     * The ARN of the API destination.
     */
    val apiDestinationArn: kotlin.String? = builder.apiDestinationArn
    /**
     * The state of the API destination.
     */
    val apiDestinationState: aws.sdk.kotlin.services.eventbridge.model.ApiDestinationState? = builder.apiDestinationState
    /**
     * The ARN of the connection specified for the API destination.
     */
    val connectionArn: kotlin.String? = builder.connectionArn
    /**
     * A time stamp for the time that the API destination was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The method to use to connect to the HTTP endpoint.
     */
    val httpMethod: aws.sdk.kotlin.services.eventbridge.model.ApiDestinationHttpMethod? = builder.httpMethod
    /**
     * The URL to the endpoint for the API destination.
     */
    val invocationEndpoint: kotlin.String? = builder.invocationEndpoint
    /**
     * The maximum number of invocations per second to send to the HTTP endpoint.
     */
    val invocationRateLimitPerSecond: kotlin.Int? = builder.invocationRateLimitPerSecond
    /**
     * A time stamp for the time that the API destination was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the API destination.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.ApiDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApiDestination(")
        append("apiDestinationArn=$apiDestinationArn,")
        append("apiDestinationState=$apiDestinationState,")
        append("connectionArn=$connectionArn,")
        append("creationTime=$creationTime,")
        append("httpMethod=$httpMethod,")
        append("invocationEndpoint=$invocationEndpoint,")
        append("invocationRateLimitPerSecond=$invocationRateLimitPerSecond,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiDestinationArn?.hashCode() ?: 0
        result = 31 * result + (apiDestinationState?.hashCode() ?: 0)
        result = 31 * result + (connectionArn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (invocationEndpoint?.hashCode() ?: 0)
        result = 31 * result + (invocationRateLimitPerSecond ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApiDestination

        if (apiDestinationArn != other.apiDestinationArn) return false
        if (apiDestinationState != other.apiDestinationState) return false
        if (connectionArn != other.connectionArn) return false
        if (creationTime != other.creationTime) return false
        if (httpMethod != other.httpMethod) return false
        if (invocationEndpoint != other.invocationEndpoint) return false
        if (invocationRateLimitPerSecond != other.invocationRateLimitPerSecond) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.ApiDestination = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the API destination.
         */
        var apiDestinationArn: kotlin.String? = null
        /**
         * The state of the API destination.
         */
        var apiDestinationState: aws.sdk.kotlin.services.eventbridge.model.ApiDestinationState? = null
        /**
         * The ARN of the connection specified for the API destination.
         */
        var connectionArn: kotlin.String? = null
        /**
         * A time stamp for the time that the API destination was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The method to use to connect to the HTTP endpoint.
         */
        var httpMethod: aws.sdk.kotlin.services.eventbridge.model.ApiDestinationHttpMethod? = null
        /**
         * The URL to the endpoint for the API destination.
         */
        var invocationEndpoint: kotlin.String? = null
        /**
         * The maximum number of invocations per second to send to the HTTP endpoint.
         */
        var invocationRateLimitPerSecond: kotlin.Int? = null
        /**
         * A time stamp for the time that the API destination was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the API destination.
         */
        var name: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.ApiDestination) : this() {
            this.apiDestinationArn = x.apiDestinationArn
            this.apiDestinationState = x.apiDestinationState
            this.connectionArn = x.connectionArn
            this.creationTime = x.creationTime
            this.httpMethod = x.httpMethod
            this.invocationEndpoint = x.invocationEndpoint
            this.invocationRateLimitPerSecond = x.invocationRateLimitPerSecond
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.ApiDestination = ApiDestination(this)
    }
}
