// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Archive object that contains details about an archive.
 */
class Archive private constructor(builder: Builder) {
    /**
     * The name of the archive.
     */
    val archiveName: kotlin.String? = builder.archiveName
    /**
     * The time stamp for the time that the archive was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The number of events in the archive.
     */
    val eventCount: kotlin.Long = builder.eventCount
    /**
     * The ARN of the event bus associated with the archive. Only events from this event bus are
     * sent to the archive.
     */
    val eventSourceArn: kotlin.String? = builder.eventSourceArn
    /**
     * The number of days to retain events in the archive before they are deleted.
     */
    val retentionDays: kotlin.Int? = builder.retentionDays
    /**
     * The size of the archive, in bytes.
     */
    val sizeBytes: kotlin.Long = builder.sizeBytes
    /**
     * The current state of the archive.
     */
    val state: aws.sdk.kotlin.services.eventbridge.model.ArchiveState? = builder.state
    /**
     * A description for the reason that the archive is in the current state.
     */
    val stateReason: kotlin.String? = builder.stateReason

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.Archive = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Archive(")
        append("archiveName=$archiveName,")
        append("creationTime=$creationTime,")
        append("eventCount=$eventCount,")
        append("eventSourceArn=$eventSourceArn,")
        append("retentionDays=$retentionDays,")
        append("sizeBytes=$sizeBytes,")
        append("state=$state,")
        append("stateReason=$stateReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveName?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (eventCount.hashCode())
        result = 31 * result + (eventSourceArn?.hashCode() ?: 0)
        result = 31 * result + (retentionDays ?: 0)
        result = 31 * result + (sizeBytes.hashCode())
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Archive

        if (archiveName != other.archiveName) return false
        if (creationTime != other.creationTime) return false
        if (eventCount != other.eventCount) return false
        if (eventSourceArn != other.eventSourceArn) return false
        if (retentionDays != other.retentionDays) return false
        if (sizeBytes != other.sizeBytes) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.Archive = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the archive.
         */
        var archiveName: kotlin.String? = null
        /**
         * The time stamp for the time that the archive was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of events in the archive.
         */
        var eventCount: kotlin.Long = 0L
        /**
         * The ARN of the event bus associated with the archive. Only events from this event bus are
         * sent to the archive.
         */
        var eventSourceArn: kotlin.String? = null
        /**
         * The number of days to retain events in the archive before they are deleted.
         */
        var retentionDays: kotlin.Int? = null
        /**
         * The size of the archive, in bytes.
         */
        var sizeBytes: kotlin.Long = 0L
        /**
         * The current state of the archive.
         */
        var state: aws.sdk.kotlin.services.eventbridge.model.ArchiveState? = null
        /**
         * A description for the reason that the archive is in the current state.
         */
        var stateReason: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.Archive) : this() {
            this.archiveName = x.archiveName
            this.creationTime = x.creationTime
            this.eventCount = x.eventCount
            this.eventSourceArn = x.eventSourceArn
            this.retentionDays = x.retentionDays
            this.sizeBytes = x.sizeBytes
            this.state = x.state
            this.stateReason = x.stateReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.Archive = Archive(this)
    }
}
