// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



/**
 * Contains the response parameters when OAuth is specified as the authorization type.
 */
class ConnectionOAuthResponseParameters private constructor(builder: Builder) {
    /**
     * The URL to the HTTP endpoint that authorized the request.
     */
    val authorizationEndpoint: kotlin.String? = builder.authorizationEndpoint
    /**
     * A ConnectionOAuthClientResponseParameters object that contains details about
     * the client parameters returned when OAuth is specified as the authorization type.
     */
    val clientParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthClientResponseParameters? = builder.clientParameters
    /**
     * The method used to connect to the HTTP endpoint.
     */
    val httpMethod: aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthHttpMethod? = builder.httpMethod
    /**
     * The additional HTTP parameters used for the OAuth authorization request.
     */
    val oAuthHttpParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters? = builder.oAuthHttpParameters

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthResponseParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectionOAuthResponseParameters(")
        append("authorizationEndpoint=$authorizationEndpoint,")
        append("clientParameters=$clientParameters,")
        append("httpMethod=$httpMethod,")
        append("oAuthHttpParameters=$oAuthHttpParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizationEndpoint?.hashCode() ?: 0
        result = 31 * result + (clientParameters?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (oAuthHttpParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectionOAuthResponseParameters

        if (authorizationEndpoint != other.authorizationEndpoint) return false
        if (clientParameters != other.clientParameters) return false
        if (httpMethod != other.httpMethod) return false
        if (oAuthHttpParameters != other.oAuthHttpParameters) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthResponseParameters = Builder(this).apply(block).build()

    class Builder {
        /**
         * The URL to the HTTP endpoint that authorized the request.
         */
        var authorizationEndpoint: kotlin.String? = null
        /**
         * A ConnectionOAuthClientResponseParameters object that contains details about
         * the client parameters returned when OAuth is specified as the authorization type.
         */
        var clientParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthClientResponseParameters? = null
        /**
         * The method used to connect to the HTTP endpoint.
         */
        var httpMethod: aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthHttpMethod? = null
        /**
         * The additional HTTP parameters used for the OAuth authorization request.
         */
        var oAuthHttpParameters: aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthResponseParameters) : this() {
            this.authorizationEndpoint = x.authorizationEndpoint
            this.clientParameters = x.clientParameters
            this.httpMethod = x.httpMethod
            this.oAuthHttpParameters = x.oAuthHttpParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthResponseParameters = ConnectionOAuthResponseParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthClientResponseParameters] inside the given [block]
         */
        fun clientParameters(block: aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthClientResponseParameters.Builder.() -> kotlin.Unit) {
            this.clientParameters = aws.sdk.kotlin.services.eventbridge.model.ConnectionOAuthClientResponseParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters] inside the given [block]
         */
        fun oAuthHttpParameters(block: aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters.Builder.() -> kotlin.Unit) {
            this.oAuthHttpParameters = aws.sdk.kotlin.services.eventbridge.model.ConnectionHttpParameters.invoke(block)
        }
    }
}
