// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



/**
 * Contains the parameters needed for you to provide custom input to a target based on one or
 * more pieces of data extracted from the event.
 */
class InputTransformer private constructor(builder: Builder) {
    /**
     * Map of JSON paths to be extracted from the event. You can then insert these in the
     * template in InputTemplate to produce the output you want to be sent to the
     * target.
     * InputPathsMap is an array key-value pairs, where each value is a valid JSON
     * path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket
     * notation.
     * The keys cannot start with "Amazon Web Services."
     */
    val inputPathsMap: Map<String, String>? = builder.inputPathsMap
    /**
     * Input template where you specify placeholders that will be filled with the values of the
     * keys from InputPathsMap to customize the data sent to the target. Enclose each
     * InputPathsMaps value in brackets: <value> The
     * InputTemplate must be valid JSON.
     * If InputTemplate is a JSON object (surrounded by curly braces), the following
     * restrictions apply:
     * The placeholder cannot be used as an object key.
     * The following example shows the syntax for using InputPathsMap and
     * InputTemplate.
     * "InputTransformer":
     * {
     * "InputPathsMap": {"instance": "$.detail.instance","status":
     * "$.detail.status"},
     * "InputTemplate": "<instance> is in state <status>"
     * }
     * To have the InputTemplate include quote marks within a JSON string, escape
     * each quote marks with a slash, as in the following example:
     * "InputTransformer":
     * {
     * "InputPathsMap": {"instance": "$.detail.instance","status":
     * "$.detail.status"},
     * "InputTemplate": "<instance> is in state \"<status>\""
     * }
     * The InputTemplate can also be valid JSON with varibles in quotes or out, as
     * in the following example:
     * "InputTransformer":
     * {
     * "InputPathsMap": {"instance": "$.detail.instance","status":
     * "$.detail.status"},
     * "InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is
     * in state \"<status>\""}'
     * }
     */
    val inputTemplate: kotlin.String? = builder.inputTemplate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.InputTransformer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputTransformer(")
        append("inputPathsMap=$inputPathsMap,")
        append("inputTemplate=$inputTemplate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputPathsMap?.hashCode() ?: 0
        result = 31 * result + (inputTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputTransformer

        if (inputPathsMap != other.inputPathsMap) return false
        if (inputTemplate != other.inputTemplate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.InputTransformer = Builder(this).apply(block).build()

    class Builder {
        /**
         * Map of JSON paths to be extracted from the event. You can then insert these in the
         * template in InputTemplate to produce the output you want to be sent to the
         * target.
         * InputPathsMap is an array key-value pairs, where each value is a valid JSON
         * path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket
         * notation.
         * The keys cannot start with "Amazon Web Services."
         */
        var inputPathsMap: Map<String, String>? = null
        /**
         * Input template where you specify placeholders that will be filled with the values of the
         * keys from InputPathsMap to customize the data sent to the target. Enclose each
         * InputPathsMaps value in brackets: <value> The
         * InputTemplate must be valid JSON.
         * If InputTemplate is a JSON object (surrounded by curly braces), the following
         * restrictions apply:
         * The placeholder cannot be used as an object key.
         * The following example shows the syntax for using InputPathsMap and
         * InputTemplate.
         * "InputTransformer":
         * {
         * "InputPathsMap": {"instance": "$.detail.instance","status":
         * "$.detail.status"},
         * "InputTemplate": "<instance> is in state <status>"
         * }
         * To have the InputTemplate include quote marks within a JSON string, escape
         * each quote marks with a slash, as in the following example:
         * "InputTransformer":
         * {
         * "InputPathsMap": {"instance": "$.detail.instance","status":
         * "$.detail.status"},
         * "InputTemplate": "<instance> is in state \"<status>\""
         * }
         * The InputTemplate can also be valid JSON with varibles in quotes or out, as
         * in the following example:
         * "InputTransformer":
         * {
         * "InputPathsMap": {"instance": "$.detail.instance","status":
         * "$.detail.status"},
         * "InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is
         * in state \"<status>\""}'
         * }
         */
        var inputTemplate: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.InputTransformer) : this() {
            this.inputPathsMap = x.inputPathsMap
            this.inputTemplate = x.inputTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.InputTransformer = InputTransformer(this)
    }
}
