// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



/**
 * This object enables you to specify a JSON path to extract from the event and use as the
 * partition key for the Amazon Kinesis data stream, so that you can control the shard to which
 * the event goes. If you do not include this parameter, the default is to use the
 * eventId as the partition key.
 */
class KinesisParameters private constructor(builder: Builder) {
    /**
     * The JSON path to be extracted from the event and used as the partition key. For more
     * information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key
     * Concepts in the Amazon Kinesis Streams Developer Guide.
     */
    val partitionKeyPath: kotlin.String? = builder.partitionKeyPath

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.KinesisParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisParameters(")
        append("partitionKeyPath=$partitionKeyPath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = partitionKeyPath?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisParameters

        if (partitionKeyPath != other.partitionKeyPath) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.KinesisParameters = Builder(this).apply(block).build()

    class Builder {
        /**
         * The JSON path to be extracted from the event and used as the partition key. For more
         * information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key
         * Concepts in the Amazon Kinesis Streams Developer Guide.
         */
        var partitionKeyPath: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.KinesisParameters) : this() {
            this.partitionKeyPath = x.partitionKeyPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.KinesisParameters = KinesisParameters(this)
    }
}
