// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



/**
 * An object representing a constraint on task placement. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task Placement Constraints in the Amazon Elastic Container Service Developer
 * Guide.
 */
class PlacementConstraint private constructor(builder: Builder) {
    /**
     * A cluster query language expression to apply to the constraint. You cannot specify an
     * expression if the constraint type is distinctInstance. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language in the Amazon Elastic Container Service Developer Guide.
     */
    val expression: kotlin.String? = builder.expression
    /**
     * The type of constraint. Use distinctInstance to ensure that each task in a particular
     * group is running on a different container instance. Use memberOf to restrict the selection to
     * a group of valid candidates.
     */
    val type: aws.sdk.kotlin.services.eventbridge.model.PlacementConstraintType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.PlacementConstraint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlacementConstraint(")
        append("expression=$expression,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = expression?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlacementConstraint

        if (expression != other.expression) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.PlacementConstraint = Builder(this).apply(block).build()

    class Builder {
        /**
         * A cluster query language expression to apply to the constraint. You cannot specify an
         * expression if the constraint type is distinctInstance. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language in the Amazon Elastic Container Service Developer Guide.
         */
        var expression: kotlin.String? = null
        /**
         * The type of constraint. Use distinctInstance to ensure that each task in a particular
         * group is running on a different container instance. Use memberOf to restrict the selection to
         * a group of valid candidates.
         */
        var type: aws.sdk.kotlin.services.eventbridge.model.PlacementConstraintType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.PlacementConstraint) : this() {
            this.expression = x.expression
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.PlacementConstraint = PlacementConstraint(this)
    }
}
