// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



class PutRuleRequest private constructor(builder: Builder) {
    /**
     * A description of the rule.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name or ARN of the event bus to associate with this rule. If you omit this, the
     * default event bus is used.
     */
    val eventBusName: kotlin.String? = builder.eventBusName
    /**
     * The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
     * Patterns in the Amazon EventBridge User Guide.
     */
    val eventPattern: kotlin.String? = builder.eventPattern
    /**
     * The name of the rule that you are creating or updating.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the IAM role associated with the rule.
     * If you're setting an event bus in another account as the target and that account granted
     * permission to your account through an organization instead of directly by the account ID, you
     * must specify a RoleArn with proper permissions in the Target
     * structure, instead of here in this parameter.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".
     */
    val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * Indicates whether the rule is enabled or disabled.
     */
    val state: aws.sdk.kotlin.services.eventbridge.model.RuleState? = builder.state
    /**
     * The list of key-value pairs to associate with the rule.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.PutRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRuleRequest(")
        append("description=$description,")
        append("eventBusName=$eventBusName,")
        append("eventPattern=$eventPattern,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("scheduleExpression=$scheduleExpression,")
        append("state=$state,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (eventBusName?.hashCode() ?: 0)
        result = 31 * result + (eventPattern?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRuleRequest

        if (description != other.description) return false
        if (eventBusName != other.eventBusName) return false
        if (eventPattern != other.eventPattern) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.PutRuleRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A description of the rule.
         */
        var description: kotlin.String? = null
        /**
         * The name or ARN of the event bus to associate with this rule. If you omit this, the
         * default event bus is used.
         */
        var eventBusName: kotlin.String? = null
        /**
         * The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
         * Patterns in the Amazon EventBridge User Guide.
         */
        var eventPattern: kotlin.String? = null
        /**
         * The name of the rule that you are creating or updating.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role associated with the rule.
         * If you're setting an event bus in another account as the target and that account granted
         * permission to your account through an organization instead of directly by the account ID, you
         * must specify a RoleArn with proper permissions in the Target
         * structure, instead of here in this parameter.
         */
        var roleArn: kotlin.String? = null
        /**
         * The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".
         */
        var scheduleExpression: kotlin.String? = null
        /**
         * Indicates whether the rule is enabled or disabled.
         */
        var state: aws.sdk.kotlin.services.eventbridge.model.RuleState? = null
        /**
         * The list of key-value pairs to associate with the rule.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.PutRuleRequest) : this() {
            this.description = x.description
            this.eventBusName = x.eventBusName
            this.eventPattern = x.eventPattern
            this.name = x.name
            this.roleArn = x.roleArn
            this.scheduleExpression = x.scheduleExpression
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.PutRuleRequest = PutRuleRequest(this)
    }
}
