// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



/**
 * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the
 * Amazon Redshift Data API ExecuteStatement based on EventBridge events.
 */
class RedshiftDataParameters private constructor(builder: Builder) {
    /**
     * The name of the database. Required when authenticating using temporary credentials.
     */
    val database: kotlin.String? = builder.database
    /**
     * The database user name. Required when authenticating using temporary credentials.
     */
    val dbUser: kotlin.String? = builder.dbUser
    /**
     * The name or ARN of the secret that enables access to the database. Required when
     * authenticating using Amazon Web Services Secrets Manager.
     */
    val secretManagerArn: kotlin.String? = builder.secretManagerArn
    /**
     * The SQL statement text to run.
     */
    val sql: kotlin.String? = builder.sql
    /**
     * The name of the SQL statement. You can name the SQL statement when you create it to
     * identify the query.
     */
    val statementName: kotlin.String? = builder.statementName
    /**
     * Indicates whether to send an event back to EventBridge after the SQL statement
     * runs.
     */
    val withEvent: kotlin.Boolean = builder.withEvent

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.RedshiftDataParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDataParameters(")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("secretManagerArn=$secretManagerArn,")
        append("sql=$sql,")
        append("statementName=$statementName,")
        append("withEvent=$withEvent)")
    }

    override fun hashCode(): kotlin.Int {
        var result = database?.hashCode() ?: 0
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (secretManagerArn?.hashCode() ?: 0)
        result = 31 * result + (sql?.hashCode() ?: 0)
        result = 31 * result + (statementName?.hashCode() ?: 0)
        result = 31 * result + (withEvent.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDataParameters

        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (secretManagerArn != other.secretManagerArn) return false
        if (sql != other.sql) return false
        if (statementName != other.statementName) return false
        if (withEvent != other.withEvent) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.RedshiftDataParameters = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the database. Required when authenticating using temporary credentials.
         */
        var database: kotlin.String? = null
        /**
         * The database user name. Required when authenticating using temporary credentials.
         */
        var dbUser: kotlin.String? = null
        /**
         * The name or ARN of the secret that enables access to the database. Required when
         * authenticating using Amazon Web Services Secrets Manager.
         */
        var secretManagerArn: kotlin.String? = null
        /**
         * The SQL statement text to run.
         */
        var sql: kotlin.String? = null
        /**
         * The name of the SQL statement. You can name the SQL statement when you create it to
         * identify the query.
         */
        var statementName: kotlin.String? = null
        /**
         * Indicates whether to send an event back to EventBridge after the SQL statement
         * runs.
         */
        var withEvent: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.RedshiftDataParameters) : this() {
            this.database = x.database
            this.dbUser = x.dbUser
            this.secretManagerArn = x.secretManagerArn
            this.sql = x.sql
            this.statementName = x.statementName
            this.withEvent = x.withEvent
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.RedshiftDataParameters = RedshiftDataParameters(this)
    }
}
