// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



/**
 * Targets are the resources to be invoked when a rule is triggered. For a complete list of
 * services and resources that can be set as a target, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutTargets.html">PutTargets.
 * If you are setting the event bus of another account as the target, and that account
 * granted permission to your account through an organization instead of directly by the account
 * ID, then you must specify a RoleArn with proper permissions in the
 * Target structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and
 * Receiving Events Between Amazon Web Services Accounts in the Amazon EventBridge User
 * Guide.
 */
class Target private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * If the event target is an Batch job, this contains the job definition, job name, and
     * other parameters. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs in the Batch User
     * Guide.
     */
    val batchParameters: aws.sdk.kotlin.services.eventbridge.model.BatchParameters? = builder.batchParameters
    /**
     * The DeadLetterConfig that defines the target queue to send dead-letter queue
     * events to.
     */
    val deadLetterConfig: aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig? = builder.deadLetterConfig
    /**
     * Contains the Amazon ECS task definition and task count to be used, if the event target is
     * an Amazon ECS task. For more information about Amazon ECS tasks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task
     * Definitions  in the Amazon EC2 Container Service Developer
     * Guide.
     */
    val ecsParameters: aws.sdk.kotlin.services.eventbridge.model.EcsParameters? = builder.ecsParameters
    /**
     * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or
     * EventBridge ApiDestination.
     * If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can
     * use this parameter to specify headers, path parameters, and query string keys/values as part
     * of your target invoking request. If you're using ApiDestinations, the corresponding Connection
     * can also have these values configured. In case of any conflicting keys, values from the
     * Connection take precedence.
     */
    val httpParameters: aws.sdk.kotlin.services.eventbridge.model.HttpParameters? = builder.httpParameters
    /**
     * The ID of the target. We recommend using a memorable and unique string.
     */
    val id: kotlin.String? = builder.id
    /**
     * Valid JSON text passed to the target. In this case, nothing from the event itself is
     * passed to the target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data
     * Interchange Format.
     */
    val input: kotlin.String? = builder.input
    /**
     * The value of the JSONPath that is used for extracting part of the matched event when
     * passing it to the target. You must use JSON dot notation, not bracket notation. For more
     * information about JSON paths, see <a href="http://goessner.net/articles/JsonPath/">JSONPath.
     */
    val inputPath: kotlin.String? = builder.inputPath
    /**
     * Settings to enable you to provide custom input to a target based on certain event data.
     * You can extract one or more key-value pairs from the event and then use that data to send
     * customized input to the target.
     */
    val inputTransformer: aws.sdk.kotlin.services.eventbridge.model.InputTransformer? = builder.inputTransformer
    /**
     * The custom parameter you can use to control the shard assignment, when the target is a
     * Kinesis data stream. If you do not include this parameter, the default is to use the
     * eventId as the partition key.
     */
    val kinesisParameters: aws.sdk.kotlin.services.eventbridge.model.KinesisParameters? = builder.kinesisParameters
    /**
     * Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift
     * cluster.
     * If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to
     * invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
     */
    val redshiftDataParameters: aws.sdk.kotlin.services.eventbridge.model.RedshiftDataParameters? = builder.redshiftDataParameters
    /**
     * The RetryPolicy object that contains the retry policy configuration to use
     * for the dead-letter queue.
     */
    val retryPolicy: aws.sdk.kotlin.services.eventbridge.model.RetryPolicy? = builder.retryPolicy
    /**
     * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is
     * triggered. If one rule triggers multiple targets, you can use a different IAM role for each
     * target.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
     */
    val runCommandParameters: aws.sdk.kotlin.services.eventbridge.model.RunCommandParameters? = builder.runCommandParameters
    /**
     * Contains the SageMaker Model Building Pipeline parameters to start execution of a
     * SageMaker Model Building Pipeline.
     * If you specify a SageMaker Model Building Pipeline as a target, you can use this to
     * specify parameters to start a pipeline execution based on EventBridge events.
     */
    val sageMakerPipelineParameters: aws.sdk.kotlin.services.eventbridge.model.SageMakerPipelineParameters? = builder.sageMakerPipelineParameters
    /**
     * Contains the message group ID to use when the target is a FIFO queue.
     * If you specify an SQS FIFO queue as a target, the queue must have content-based
     * deduplication enabled.
     */
    val sqsParameters: aws.sdk.kotlin.services.eventbridge.model.SqsParameters? = builder.sqsParameters

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.Target = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Target(")
        append("arn=$arn,")
        append("batchParameters=$batchParameters,")
        append("deadLetterConfig=$deadLetterConfig,")
        append("ecsParameters=$ecsParameters,")
        append("httpParameters=$httpParameters,")
        append("id=$id,")
        append("input=$input,")
        append("inputPath=$inputPath,")
        append("inputTransformer=$inputTransformer,")
        append("kinesisParameters=$kinesisParameters,")
        append("redshiftDataParameters=$redshiftDataParameters,")
        append("retryPolicy=$retryPolicy,")
        append("roleArn=$roleArn,")
        append("runCommandParameters=$runCommandParameters,")
        append("sageMakerPipelineParameters=$sageMakerPipelineParameters,")
        append("sqsParameters=$sqsParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (batchParameters?.hashCode() ?: 0)
        result = 31 * result + (deadLetterConfig?.hashCode() ?: 0)
        result = 31 * result + (ecsParameters?.hashCode() ?: 0)
        result = 31 * result + (httpParameters?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (inputPath?.hashCode() ?: 0)
        result = 31 * result + (inputTransformer?.hashCode() ?: 0)
        result = 31 * result + (kinesisParameters?.hashCode() ?: 0)
        result = 31 * result + (redshiftDataParameters?.hashCode() ?: 0)
        result = 31 * result + (retryPolicy?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (runCommandParameters?.hashCode() ?: 0)
        result = 31 * result + (sageMakerPipelineParameters?.hashCode() ?: 0)
        result = 31 * result + (sqsParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Target

        if (arn != other.arn) return false
        if (batchParameters != other.batchParameters) return false
        if (deadLetterConfig != other.deadLetterConfig) return false
        if (ecsParameters != other.ecsParameters) return false
        if (httpParameters != other.httpParameters) return false
        if (id != other.id) return false
        if (input != other.input) return false
        if (inputPath != other.inputPath) return false
        if (inputTransformer != other.inputTransformer) return false
        if (kinesisParameters != other.kinesisParameters) return false
        if (redshiftDataParameters != other.redshiftDataParameters) return false
        if (retryPolicy != other.retryPolicy) return false
        if (roleArn != other.roleArn) return false
        if (runCommandParameters != other.runCommandParameters) return false
        if (sageMakerPipelineParameters != other.sageMakerPipelineParameters) return false
        if (sqsParameters != other.sqsParameters) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.Target = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        var arn: kotlin.String? = null
        /**
         * If the event target is an Batch job, this contains the job definition, job name, and
         * other parameters. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs in the Batch User
         * Guide.
         */
        var batchParameters: aws.sdk.kotlin.services.eventbridge.model.BatchParameters? = null
        /**
         * The DeadLetterConfig that defines the target queue to send dead-letter queue
         * events to.
         */
        var deadLetterConfig: aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig? = null
        /**
         * Contains the Amazon ECS task definition and task count to be used, if the event target is
         * an Amazon ECS task. For more information about Amazon ECS tasks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task
         * Definitions  in the Amazon EC2 Container Service Developer
         * Guide.
         */
        var ecsParameters: aws.sdk.kotlin.services.eventbridge.model.EcsParameters? = null
        /**
         * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or
         * EventBridge ApiDestination.
         * If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can
         * use this parameter to specify headers, path parameters, and query string keys/values as part
         * of your target invoking request. If you're using ApiDestinations, the corresponding Connection
         * can also have these values configured. In case of any conflicting keys, values from the
         * Connection take precedence.
         */
        var httpParameters: aws.sdk.kotlin.services.eventbridge.model.HttpParameters? = null
        /**
         * The ID of the target. We recommend using a memorable and unique string.
         */
        var id: kotlin.String? = null
        /**
         * Valid JSON text passed to the target. In this case, nothing from the event itself is
         * passed to the target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data
         * Interchange Format.
         */
        var input: kotlin.String? = null
        /**
         * The value of the JSONPath that is used for extracting part of the matched event when
         * passing it to the target. You must use JSON dot notation, not bracket notation. For more
         * information about JSON paths, see <a href="http://goessner.net/articles/JsonPath/">JSONPath.
         */
        var inputPath: kotlin.String? = null
        /**
         * Settings to enable you to provide custom input to a target based on certain event data.
         * You can extract one or more key-value pairs from the event and then use that data to send
         * customized input to the target.
         */
        var inputTransformer: aws.sdk.kotlin.services.eventbridge.model.InputTransformer? = null
        /**
         * The custom parameter you can use to control the shard assignment, when the target is a
         * Kinesis data stream. If you do not include this parameter, the default is to use the
         * eventId as the partition key.
         */
        var kinesisParameters: aws.sdk.kotlin.services.eventbridge.model.KinesisParameters? = null
        /**
         * Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift
         * cluster.
         * If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to
         * invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
         */
        var redshiftDataParameters: aws.sdk.kotlin.services.eventbridge.model.RedshiftDataParameters? = null
        /**
         * The RetryPolicy object that contains the retry policy configuration to use
         * for the dead-letter queue.
         */
        var retryPolicy: aws.sdk.kotlin.services.eventbridge.model.RetryPolicy? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is
         * triggered. If one rule triggers multiple targets, you can use a different IAM role for each
         * target.
         */
        var roleArn: kotlin.String? = null
        /**
         * Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
         */
        var runCommandParameters: aws.sdk.kotlin.services.eventbridge.model.RunCommandParameters? = null
        /**
         * Contains the SageMaker Model Building Pipeline parameters to start execution of a
         * SageMaker Model Building Pipeline.
         * If you specify a SageMaker Model Building Pipeline as a target, you can use this to
         * specify parameters to start a pipeline execution based on EventBridge events.
         */
        var sageMakerPipelineParameters: aws.sdk.kotlin.services.eventbridge.model.SageMakerPipelineParameters? = null
        /**
         * Contains the message group ID to use when the target is a FIFO queue.
         * If you specify an SQS FIFO queue as a target, the queue must have content-based
         * deduplication enabled.
         */
        var sqsParameters: aws.sdk.kotlin.services.eventbridge.model.SqsParameters? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.Target) : this() {
            this.arn = x.arn
            this.batchParameters = x.batchParameters
            this.deadLetterConfig = x.deadLetterConfig
            this.ecsParameters = x.ecsParameters
            this.httpParameters = x.httpParameters
            this.id = x.id
            this.input = x.input
            this.inputPath = x.inputPath
            this.inputTransformer = x.inputTransformer
            this.kinesisParameters = x.kinesisParameters
            this.redshiftDataParameters = x.redshiftDataParameters
            this.retryPolicy = x.retryPolicy
            this.roleArn = x.roleArn
            this.runCommandParameters = x.runCommandParameters
            this.sageMakerPipelineParameters = x.sageMakerPipelineParameters
            this.sqsParameters = x.sqsParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.Target = Target(this)

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.BatchParameters] inside the given [block]
         */
        fun batchParameters(block: aws.sdk.kotlin.services.eventbridge.model.BatchParameters.Builder.() -> kotlin.Unit) {
            this.batchParameters = aws.sdk.kotlin.services.eventbridge.model.BatchParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig] inside the given [block]
         */
        fun deadLetterConfig(block: aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig.Builder.() -> kotlin.Unit) {
            this.deadLetterConfig = aws.sdk.kotlin.services.eventbridge.model.DeadLetterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.EcsParameters] inside the given [block]
         */
        fun ecsParameters(block: aws.sdk.kotlin.services.eventbridge.model.EcsParameters.Builder.() -> kotlin.Unit) {
            this.ecsParameters = aws.sdk.kotlin.services.eventbridge.model.EcsParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.HttpParameters] inside the given [block]
         */
        fun httpParameters(block: aws.sdk.kotlin.services.eventbridge.model.HttpParameters.Builder.() -> kotlin.Unit) {
            this.httpParameters = aws.sdk.kotlin.services.eventbridge.model.HttpParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.InputTransformer] inside the given [block]
         */
        fun inputTransformer(block: aws.sdk.kotlin.services.eventbridge.model.InputTransformer.Builder.() -> kotlin.Unit) {
            this.inputTransformer = aws.sdk.kotlin.services.eventbridge.model.InputTransformer.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.KinesisParameters] inside the given [block]
         */
        fun kinesisParameters(block: aws.sdk.kotlin.services.eventbridge.model.KinesisParameters.Builder.() -> kotlin.Unit) {
            this.kinesisParameters = aws.sdk.kotlin.services.eventbridge.model.KinesisParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.RedshiftDataParameters] inside the given [block]
         */
        fun redshiftDataParameters(block: aws.sdk.kotlin.services.eventbridge.model.RedshiftDataParameters.Builder.() -> kotlin.Unit) {
            this.redshiftDataParameters = aws.sdk.kotlin.services.eventbridge.model.RedshiftDataParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.RetryPolicy] inside the given [block]
         */
        fun retryPolicy(block: aws.sdk.kotlin.services.eventbridge.model.RetryPolicy.Builder.() -> kotlin.Unit) {
            this.retryPolicy = aws.sdk.kotlin.services.eventbridge.model.RetryPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.RunCommandParameters] inside the given [block]
         */
        fun runCommandParameters(block: aws.sdk.kotlin.services.eventbridge.model.RunCommandParameters.Builder.() -> kotlin.Unit) {
            this.runCommandParameters = aws.sdk.kotlin.services.eventbridge.model.RunCommandParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.SageMakerPipelineParameters] inside the given [block]
         */
        fun sageMakerPipelineParameters(block: aws.sdk.kotlin.services.eventbridge.model.SageMakerPipelineParameters.Builder.() -> kotlin.Unit) {
            this.sageMakerPipelineParameters = aws.sdk.kotlin.services.eventbridge.model.SageMakerPipelineParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eventbridge.model.SqsParameters] inside the given [block]
         */
        fun sqsParameters(block: aws.sdk.kotlin.services.eventbridge.model.SqsParameters.Builder.() -> kotlin.Unit) {
            this.sqsParameters = aws.sdk.kotlin.services.eventbridge.model.SqsParameters.invoke(block)
        }
    }
}
