// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.model



class TestEventPatternRequest private constructor(builder: Builder) {
    /**
     * The event, in JSON format, to test against the event pattern. The JSON must follow the
     * format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events, and the following
     * fields are mandatory:
     * id
     * account
     * source
     * time
     * region
     * resources
     * detail-type
     */
    val event: kotlin.String? = builder.event
    /**
     * The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
     * Patterns in the Amazon EventBridge User Guide.
     */
    val eventPattern: kotlin.String? = builder.eventPattern

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eventbridge.model.TestEventPatternRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestEventPatternRequest(")
        append("event=$event,")
        append("eventPattern=$eventPattern)")
    }

    override fun hashCode(): kotlin.Int {
        var result = event?.hashCode() ?: 0
        result = 31 * result + (eventPattern?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestEventPatternRequest

        if (event != other.event) return false
        if (eventPattern != other.eventPattern) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eventbridge.model.TestEventPatternRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The event, in JSON format, to test against the event pattern. The JSON must follow the
         * format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events, and the following
         * fields are mandatory:
         * id
         * account
         * source
         * time
         * region
         * resources
         * detail-type
         */
        var event: kotlin.String? = null
        /**
         * The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
         * Patterns in the Amazon EventBridge User Guide.
         */
        var eventPattern: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eventbridge.model.TestEventPatternRequest) : this() {
            this.event = x.event
            this.eventPattern = x.eventPattern
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eventbridge.model.TestEventPatternRequest = TestEventPatternRequest(this)
    }
}
