// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthResponseParameters
import aws.sdk.kotlin.services.eventbridge.model.ConnectionAuthorizationType
import aws.sdk.kotlin.services.eventbridge.model.ConnectionState
import aws.sdk.kotlin.services.eventbridge.model.DescribeConnectionResponse
import aws.sdk.kotlin.services.eventbridge.model.EventBridgeException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeConnectionOperationDeserializer: HttpDeserialize<DescribeConnectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeConnectionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeConnectionError(context, response)
        }
        val builder = DescribeConnectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeConnectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeConnectionOperationBody(builder: DescribeConnectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AuthParameters"))
    val AUTHORIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AuthorizationType"))
    val CONNECTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionArn"))
    val CONNECTIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectionState"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LASTAUTHORIZEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastAuthorizedTime"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SECRETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretArn"))
    val STATEREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StateReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHPARAMETERS_DESCRIPTOR)
        field(AUTHORIZATIONTYPE_DESCRIPTOR)
        field(CONNECTIONARN_DESCRIPTOR)
        field(CONNECTIONSTATE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTAUTHORIZEDTIME_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SECRETARN_DESCRIPTOR)
        field(STATEREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHPARAMETERS_DESCRIPTOR.index -> builder.authParameters = deserializeConnectionAuthResponseParametersDocument(deserializer)
                AUTHORIZATIONTYPE_DESCRIPTOR.index -> builder.authorizationType = deserializeString().let { ConnectionAuthorizationType.fromValue(it) }
                CONNECTIONARN_DESCRIPTOR.index -> builder.connectionArn = deserializeString()
                CONNECTIONSTATE_DESCRIPTOR.index -> builder.connectionState = deserializeString().let { ConnectionState.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTAUTHORIZEDTIME_DESCRIPTOR.index -> builder.lastAuthorizedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SECRETARN_DESCRIPTOR.index -> builder.secretArn = deserializeString()
                STATEREASON_DESCRIPTOR.index -> builder.stateReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeConnectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EventBridgeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        else -> throw EventBridgeException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
