// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.eventbridge.model.DescribeRuleResponse
import aws.sdk.kotlin.services.eventbridge.model.EventBridgeException
import aws.sdk.kotlin.services.eventbridge.model.RuleState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeRuleOperationDeserializer: HttpDeserialize<DescribeRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeRuleResponse {
        if (!response.status.isSuccess()) {
            throwDescribeRuleError(context, response)
        }
        val builder = DescribeRuleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeRuleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeRuleOperationBody(builder: DescribeRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatedBy"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val EVENTBUSNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventBusName"))
    val EVENTPATTERN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EventPattern"))
    val MANAGEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ManagedBy"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val SCHEDULEEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ScheduleExpression"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EVENTBUSNAME_DESCRIPTOR)
        field(EVENTPATTERN_DESCRIPTOR)
        field(MANAGEDBY_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SCHEDULEEXPRESSION_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EVENTBUSNAME_DESCRIPTOR.index -> builder.eventBusName = deserializeString()
                EVENTPATTERN_DESCRIPTOR.index -> builder.eventPattern = deserializeString()
                MANAGEDBY_DESCRIPTOR.index -> builder.managedBy = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SCHEDULEEXPRESSION_DESCRIPTOR.index -> builder.scheduleExpression = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { RuleState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeRuleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EventBridgeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        else -> throw EventBridgeException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
