// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eventbridge.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.eventbridge.model.EventBridgeException
import aws.sdk.kotlin.services.eventbridge.model.PutRuleResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutRuleOperationDeserializer: HttpDeserialize<PutRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutRuleResponse {
        if (!response.status.isSuccess()) {
            throwPutRuleError(context, response)
        }
        val builder = PutRuleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutRuleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializePutRuleOperationBody(builder: PutRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RULEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RuleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RULEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RULEARN_DESCRIPTOR.index -> builder.ruleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwPutRuleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EventBridgeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer()
        "InternalException" -> InternalExceptionDeserializer()
        "InvalidEventPatternException" -> InvalidEventPatternExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ManagedRuleException" -> ManagedRuleExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        else -> throw EventBridgeException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
