// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.firehose.model.FirehoseException
import aws.sdk.kotlin.services.firehose.model.ListDeliveryStreamsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListDeliveryStreamsOperationDeserializer: HttpDeserialize<ListDeliveryStreamsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListDeliveryStreamsResponse {
        if (!response.status.isSuccess()) {
            throwListDeliveryStreamsError(context, response)
        }
        val builder = ListDeliveryStreamsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDeliveryStreamsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListDeliveryStreamsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FirehoseException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> FirehoseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListDeliveryStreamsOperationBody(builder: ListDeliveryStreamsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELIVERYSTREAMNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DeliveryStreamNames"))
    val HASMOREDELIVERYSTREAMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("HasMoreDeliveryStreams"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELIVERYSTREAMNAMES_DESCRIPTOR)
        field(HASMOREDELIVERYSTREAMS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELIVERYSTREAMNAMES_DESCRIPTOR.index -> builder.deliveryStreamNames =
                    deserializer.deserializeList(DELIVERYSTREAMNAMES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HASMOREDELIVERYSTREAMS_DESCRIPTOR.index -> builder.hasMoreDeliveryStreams = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
