// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes a `COPY` command for Amazon Redshift.
 */
public class CopyCommand private constructor(builder: Builder) {
    /**
     * Optional parameters to use with the Amazon Redshift `COPY` command. For more information, see the "Optional Parameters" section of [Amazon Redshift COPY command](https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html). Some possible examples that would apply to Kinesis Data Firehose are as follows:
     *
     * `delimiter '\t' lzop;` - fields are delimited with "\t" (TAB character) and compressed using lzop.
     *
     * `delimiter '|'` - fields are delimited with "|" (this is the default delimiter).
     *
     * `delimiter '|' escape` - the delimiter should be escaped.
     *
     * `fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'` - fields are fixed width in the source, with each width specified after every column in the table.
     *
     * `JSON 's3://mybucket/jsonpaths.txt'` - data is in JSON format, and the path specified is the format of the data.
     *
     * For more examples, see [Amazon Redshift COPY command examples](https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html).
     */
    public val copyOptions: kotlin.String? = builder.copyOptions
    /**
     * A comma-separated list of column names.
     */
    public val dataTableColumns: kotlin.String? = builder.dataTableColumns
    /**
     * The name of the target table. The table must already exist in the database.
     */
    public val dataTableName: kotlin.String? = builder.dataTableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.CopyCommand = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyCommand(")
        append("copyOptions=$copyOptions,")
        append("dataTableColumns=$dataTableColumns,")
        append("dataTableName=$dataTableName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyOptions?.hashCode() ?: 0
        result = 31 * result + (dataTableColumns?.hashCode() ?: 0)
        result = 31 * result + (dataTableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyCommand

        if (copyOptions != other.copyOptions) return false
        if (dataTableColumns != other.dataTableColumns) return false
        if (dataTableName != other.dataTableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.CopyCommand = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Optional parameters to use with the Amazon Redshift `COPY` command. For more information, see the "Optional Parameters" section of [Amazon Redshift COPY command](https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html). Some possible examples that would apply to Kinesis Data Firehose are as follows:
         *
         * `delimiter '\t' lzop;` - fields are delimited with "\t" (TAB character) and compressed using lzop.
         *
         * `delimiter '|'` - fields are delimited with "|" (this is the default delimiter).
         *
         * `delimiter '|' escape` - the delimiter should be escaped.
         *
         * `fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'` - fields are fixed width in the source, with each width specified after every column in the table.
         *
         * `JSON 's3://mybucket/jsonpaths.txt'` - data is in JSON format, and the path specified is the format of the data.
         *
         * For more examples, see [Amazon Redshift COPY command examples](https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html).
         */
        public var copyOptions: kotlin.String? = null
        /**
         * A comma-separated list of column names.
         */
        public var dataTableColumns: kotlin.String? = null
        /**
         * The name of the target table. The table must already exist in the database.
         */
        public var dataTableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.CopyCommand) : this() {
            this.copyOptions = x.copyOptions
            this.dataTableColumns = x.dataTableColumns
            this.dataTableName = x.dataTableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.CopyCommand = CopyCommand(this)
    }
}
