// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Updates the specified HTTP endpoint destination.
 */
public class HttpEndpointDestinationUpdate private constructor(builder: Builder) {
    /**
     * Describes buffering options that can be applied to the data before it is delivered to the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it might choose to use more optimal values. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if specify a value for one of them, you must also provide a value for the other.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints? = builder.bufferingHints
    /**
     * Describes the Amazon CloudWatch logging options for your delivery stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * Describes the configuration of the HTTP endpoint destination.
     */
    public val endpointConfiguration: aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration? = builder.endpointConfiguration
    /**
     * Describes a data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The configuration of the request sent to the HTTP endpoint specified as the destination.
     */
    public val requestConfiguration: aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration? = builder.requestConfiguration
    /**
     * Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
     */
    public val retryOptions: aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions? = builder.retryOptions
    /**
     * Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint destination. You can back up all documents (`AllData`) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (`FailedDataOnly`).
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.HttpEndpointS3BackupMode? = builder.s3BackupMode
    /**
     * Describes an update for a destination in Amazon S3.
     */
    public val s3Update: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = builder.s3Update

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.HttpEndpointDestinationUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpEndpointDestinationUpdate(")
        append("bufferingHints=$bufferingHints,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("processingConfiguration=$processingConfiguration,")
        append("requestConfiguration=$requestConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Update=$s3Update)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bufferingHints?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (requestConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Update?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpEndpointDestinationUpdate

        if (bufferingHints != other.bufferingHints) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (requestConfiguration != other.requestConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Update != other.s3Update) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.HttpEndpointDestinationUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes buffering options that can be applied to the data before it is delivered to the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it might choose to use more optimal values. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if specify a value for one of them, you must also provide a value for the other.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints? = null
        /**
         * Describes the Amazon CloudWatch logging options for your delivery stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * Describes the configuration of the HTTP endpoint destination.
         */
        public var endpointConfiguration: aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration? = null
        /**
         * Describes a data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The configuration of the request sent to the HTTP endpoint specified as the destination.
         */
        public var requestConfiguration: aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration? = null
        /**
         * Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
         */
        public var retryOptions: aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions? = null
        /**
         * Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint destination. You can back up all documents (`AllData`) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (`FailedDataOnly`).
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.HttpEndpointS3BackupMode? = null
        /**
         * Describes an update for a destination in Amazon S3.
         */
        public var s3Update: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.HttpEndpointDestinationUpdate) : this() {
            this.bufferingHints = x.bufferingHints
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.endpointConfiguration = x.endpointConfiguration
            this.processingConfiguration = x.processingConfiguration
            this.requestConfiguration = x.requestConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3Update = x.s3Update
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.HttpEndpointDestinationUpdate = HttpEndpointDestinationUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration] inside the given [block]
         */
        public fun endpointConfiguration(block: aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration.Builder.() -> kotlin.Unit) {
            this.endpointConfiguration = aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration] inside the given [block]
         */
        public fun requestConfiguration(block: aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration.Builder.() -> kotlin.Unit) {
            this.requestConfiguration = aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions] inside the given [block]
         */
        public fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.HttpEndpointRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate] inside the given [block]
         */
        public fun s3Update(block: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.Builder.() -> kotlin.Unit) {
            this.s3Update = aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.invoke(block)
        }
    }
}
