// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Configures retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift.
 */
public class RedshiftRetryOptions private constructor(builder: Builder) {
    /**
     * The length of time during which Kinesis Data Firehose retries delivery after a failure, starting from the initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Kinesis Data Firehose does not retry if the value of `DurationInSeconds` is 0 (zero) or if the first delivery attempt takes longer than the current value.
     */
    public val durationInSeconds: kotlin.Int? = builder.durationInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftRetryOptions(")
        append("durationInSeconds=$durationInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationInSeconds ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftRetryOptions

        if (durationInSeconds != other.durationInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The length of time during which Kinesis Data Firehose retries delivery after a failure, starting from the initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Kinesis Data Firehose does not retry if the value of `DurationInSeconds` is 0 (zero) or if the first delivery attempt takes longer than the current value.
         */
        public var durationInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions) : this() {
            this.durationInSeconds = x.durationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions = RedshiftRetryOptions(this)
    }
}
