// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * A serializer to use for converting data to the ORC format before storing it in Amazon S3. For more information, see [Apache ORC](https://orc.apache.org/docs/).
 */
public class OrcSerDe private constructor(builder: Builder) {
    /**
     * The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
     */
    public val blockSizeBytes: kotlin.Int? = builder.blockSizeBytes
    /**
     * The column names for which you want Kinesis Data Firehose to create bloom filters. The default is `null`.
     */
    public val bloomFilterColumns: List<String>? = builder.bloomFilterColumns
    /**
     * The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.
     */
    public val bloomFilterFalsePositiveProbability: kotlin.Double? = builder.bloomFilterFalsePositiveProbability
    /**
     * The compression code to use over data blocks. The default is `SNAPPY`.
     */
    public val compression: aws.sdk.kotlin.services.firehose.model.OrcCompression? = builder.compression
    /**
     * Represents the fraction of the total number of non-null rows. To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to 1.
     */
    public val dictionaryKeyThreshold: kotlin.Double? = builder.dictionaryKeyThreshold
    /**
     * Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `false`.
     */
    public val enablePadding: kotlin.Boolean? = builder.enablePadding
    /**
     * The version of the file to write. The possible values are `V0_11` and `V0_12`. The default is `V0_12`.
     */
    public val formatVersion: aws.sdk.kotlin.services.firehose.model.OrcFormatVersion? = builder.formatVersion
    /**
     * A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. The default value is 0.05, which means 5 percent of stripe size.
     *
     * For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
     *
     * Kinesis Data Firehose ignores this parameter when OrcSerDe$EnablePadding is `false`.
     */
    public val paddingTolerance: kotlin.Double? = builder.paddingTolerance
    /**
     * The number of rows between index entries. The default is 10,000 and the minimum is 1,000.
     */
    public val rowIndexStride: kotlin.Int? = builder.rowIndexStride
    /**
     * The number of bytes in each stripe. The default is 64 MiB and the minimum is 8 MiB.
     */
    public val stripeSizeBytes: kotlin.Int? = builder.stripeSizeBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.OrcSerDe = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrcSerDe(")
        append("blockSizeBytes=$blockSizeBytes,")
        append("bloomFilterColumns=$bloomFilterColumns,")
        append("bloomFilterFalsePositiveProbability=$bloomFilterFalsePositiveProbability,")
        append("compression=$compression,")
        append("dictionaryKeyThreshold=$dictionaryKeyThreshold,")
        append("enablePadding=$enablePadding,")
        append("formatVersion=$formatVersion,")
        append("paddingTolerance=$paddingTolerance,")
        append("rowIndexStride=$rowIndexStride,")
        append("stripeSizeBytes=$stripeSizeBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockSizeBytes ?: 0
        result = 31 * result + (bloomFilterColumns?.hashCode() ?: 0)
        result = 31 * result + (bloomFilterFalsePositiveProbability?.hashCode() ?: 0)
        result = 31 * result + (compression?.hashCode() ?: 0)
        result = 31 * result + (dictionaryKeyThreshold?.hashCode() ?: 0)
        result = 31 * result + (enablePadding?.hashCode() ?: 0)
        result = 31 * result + (formatVersion?.hashCode() ?: 0)
        result = 31 * result + (paddingTolerance?.hashCode() ?: 0)
        result = 31 * result + (rowIndexStride ?: 0)
        result = 31 * result + (stripeSizeBytes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrcSerDe

        if (blockSizeBytes != other.blockSizeBytes) return false
        if (bloomFilterColumns != other.bloomFilterColumns) return false
        if (bloomFilterFalsePositiveProbability != other.bloomFilterFalsePositiveProbability) return false
        if (compression != other.compression) return false
        if (dictionaryKeyThreshold != other.dictionaryKeyThreshold) return false
        if (enablePadding != other.enablePadding) return false
        if (formatVersion != other.formatVersion) return false
        if (paddingTolerance != other.paddingTolerance) return false
        if (rowIndexStride != other.rowIndexStride) return false
        if (stripeSizeBytes != other.stripeSizeBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.OrcSerDe = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
         */
        public var blockSizeBytes: kotlin.Int? = null
        /**
         * The column names for which you want Kinesis Data Firehose to create bloom filters. The default is `null`.
         */
        public var bloomFilterColumns: List<String>? = null
        /**
         * The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.
         */
        public var bloomFilterFalsePositiveProbability: kotlin.Double? = null
        /**
         * The compression code to use over data blocks. The default is `SNAPPY`.
         */
        public var compression: aws.sdk.kotlin.services.firehose.model.OrcCompression? = null
        /**
         * Represents the fraction of the total number of non-null rows. To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to 1.
         */
        public var dictionaryKeyThreshold: kotlin.Double? = null
        /**
         * Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `false`.
         */
        public var enablePadding: kotlin.Boolean? = null
        /**
         * The version of the file to write. The possible values are `V0_11` and `V0_12`. The default is `V0_12`.
         */
        public var formatVersion: aws.sdk.kotlin.services.firehose.model.OrcFormatVersion? = null
        /**
         * A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. The default value is 0.05, which means 5 percent of stripe size.
         *
         * For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
         *
         * Kinesis Data Firehose ignores this parameter when OrcSerDe$EnablePadding is `false`.
         */
        public var paddingTolerance: kotlin.Double? = null
        /**
         * The number of rows between index entries. The default is 10,000 and the minimum is 1,000.
         */
        public var rowIndexStride: kotlin.Int? = null
        /**
         * The number of bytes in each stripe. The default is 64 MiB and the minimum is 8 MiB.
         */
        public var stripeSizeBytes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.OrcSerDe) : this() {
            this.blockSizeBytes = x.blockSizeBytes
            this.bloomFilterColumns = x.bloomFilterColumns
            this.bloomFilterFalsePositiveProbability = x.bloomFilterFalsePositiveProbability
            this.compression = x.compression
            this.dictionaryKeyThreshold = x.dictionaryKeyThreshold
            this.enablePadding = x.enablePadding
            this.formatVersion = x.formatVersion
            this.paddingTolerance = x.paddingTolerance
            this.rowIndexStride = x.rowIndexStride
            this.stripeSizeBytes = x.stripeSizeBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.OrcSerDe = OrcSerDe(this)
    }
}
