// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes a destination in Amazon S3.
 */
public class S3DestinationDescription private constructor(builder: Builder) {
    /**
     * The ARN of the S3 bucket. For more information, see [Amazon Resource Names (ARNs) and AWS Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val bucketArn: kotlin.String? = builder.bucketArn
    /**
     * The buffering option. If no value is specified, `BufferingHints` object default values are used.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.BufferingHints? = builder.bufferingHints
    /**
     * The Amazon CloudWatch logging options for your delivery stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The compression format. If no value is specified, the default is `UNCOMPRESSED`.
     */
    public val compressionFormat: aws.sdk.kotlin.services.firehose.model.CompressionFormat? = builder.compressionFormat
    /**
     * The encryption configuration. If no value is specified, the default is no encryption.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
     */
    public val errorOutputPrefix: kotlin.String? = builder.errorOutputPrefix
    /**
     * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see [Amazon Resource Names (ARNs) and AWS Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.S3DestinationDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DestinationDescription(")
        append("bucketArn=$bucketArn,")
        append("bufferingHints=$bufferingHints,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("compressionFormat=$compressionFormat,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("errorOutputPrefix=$errorOutputPrefix,")
        append("prefix=$prefix,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketArn?.hashCode() ?: 0
        result = 31 * result + (bufferingHints?.hashCode() ?: 0)
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (compressionFormat?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (errorOutputPrefix?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DestinationDescription

        if (bucketArn != other.bucketArn) return false
        if (bufferingHints != other.bufferingHints) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (compressionFormat != other.compressionFormat) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (errorOutputPrefix != other.errorOutputPrefix) return false
        if (prefix != other.prefix) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.S3DestinationDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the S3 bucket. For more information, see [Amazon Resource Names (ARNs) and AWS Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var bucketArn: kotlin.String? = null
        /**
         * The buffering option. If no value is specified, `BufferingHints` object default values are used.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.BufferingHints? = null
        /**
         * The Amazon CloudWatch logging options for your delivery stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The compression format. If no value is specified, the default is `UNCOMPRESSED`.
         */
        public var compressionFormat: aws.sdk.kotlin.services.firehose.model.CompressionFormat? = null
        /**
         * The encryption configuration. If no value is specified, the default is no encryption.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration? = null
        /**
         * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
         */
        public var errorOutputPrefix: kotlin.String? = null
        /**
         * The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
         */
        public var prefix: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see [Amazon Resource Names (ARNs) and AWS Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.S3DestinationDescription) : this() {
            this.bucketArn = x.bucketArn
            this.bufferingHints = x.bufferingHints
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.compressionFormat = x.compressionFormat
            this.encryptionConfiguration = x.encryptionConfiguration
            this.errorOutputPrefix = x.errorOutputPrefix
            this.prefix = x.prefix
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.S3DestinationDescription = S3DestinationDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.BufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.BufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.BufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.firehose.model.EncryptionConfiguration.invoke(block)
        }
    }
}
