// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.firehose.model.CreateDeliveryStreamResponse
import aws.sdk.kotlin.services.firehose.model.FirehoseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDeliveryStreamOperationDeserializer: HttpDeserialize<CreateDeliveryStreamResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDeliveryStreamResponse {
        if (!response.status.isSuccess()) {
            throwCreateDeliveryStreamError(context, response)
        }
        val builder = CreateDeliveryStreamResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDeliveryStreamOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateDeliveryStreamError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FirehoseException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKMSResourceException" -> InvalidKmsResourceExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> FirehoseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDeliveryStreamOperationBody(builder: CreateDeliveryStreamResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELIVERYSTREAMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeliveryStreamARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELIVERYSTREAMARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELIVERYSTREAMARN_DESCRIPTOR.index -> builder.deliveryStreamArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
