// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
 */
public class AmazonOpenSearchServerlessDestinationConfiguration private constructor(builder: Builder) {
    /**
     * The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
     */
    public val bufferingHints: aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessBufferingHints? = builder.bufferingHints
    /**
     * Describes the Amazon CloudWatch logging options for your delivery stream.
     */
    public val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
     */
    public val collectionEndpoint: kotlin.String? = builder.collectionEndpoint
    /**
     * The Serverless offering for Amazon OpenSearch Service index name.
     */
    public val indexName: kotlin.String? = builder.indexName
    /**
     * Describes a data processing configuration.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to the Serverless offering for Amazon OpenSearch Service. The default value is 300 (5 minutes).
     */
    public val retryOptions: aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessRetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Kinesis Data Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to the prefix.
     */
    public val s3BackupMode: aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessS3BackupMode? = builder.s3BackupMode
    /**
     * Describes the configuration of a destination in Amazon S3.
     */
    public val s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = builder.s3Configuration
    /**
     * The details of the VPC of the Amazon ES destination.
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.firehose.model.VpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AmazonOpenSearchServerlessDestinationConfiguration(")
        append("bufferingHints=$bufferingHints,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("collectionEndpoint=$collectionEndpoint,")
        append("indexName=$indexName,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Configuration=$s3Configuration,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bufferingHints?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (collectionEndpoint?.hashCode() ?: 0)
        result = 31 * result + (indexName?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AmazonOpenSearchServerlessDestinationConfiguration

        if (bufferingHints != other.bufferingHints) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (collectionEndpoint != other.collectionEndpoint) return false
        if (indexName != other.indexName) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Configuration != other.s3Configuration) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
         */
        public var bufferingHints: aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessBufferingHints? = null
        /**
         * Describes the Amazon CloudWatch logging options for your delivery stream.
         */
        public var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
         */
        public var collectionEndpoint: kotlin.String? = null
        /**
         * The Serverless offering for Amazon OpenSearch Service index name.
         */
        public var indexName: kotlin.String? = null
        /**
         * Describes a data processing configuration.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to the Serverless offering for Amazon OpenSearch Service. The default value is 300 (5 minutes).
         */
        public var retryOptions: aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessRetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Defines how documents should be delivered to Amazon S3. When it is set to FailedDocumentsOnly, Kinesis Data Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to the prefix.
         */
        public var s3BackupMode: aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessS3BackupMode? = null
        /**
         * Describes the configuration of a destination in Amazon S3.
         */
        public var s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = null
        /**
         * The details of the VPC of the Amazon ES destination.
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.firehose.model.VpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration) : this() {
            this.bufferingHints = x.bufferingHints
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.collectionEndpoint = x.collectionEndpoint
            this.indexName = x.indexName
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3Configuration = x.s3Configuration
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessDestinationConfiguration = AmazonOpenSearchServerlessDestinationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessBufferingHints] inside the given [block]
         */
        public fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessBufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessBufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        public fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        public fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessRetryOptions] inside the given [block]
         */
        public fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.AmazonOpenSearchServerlessRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration] inside the given [block]
         */
        public fun s3Configuration(block: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.firehose.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.firehose.model.VpcConfiguration.invoke(block)
        }
    }
}
